/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.util.ExecutorFactory;
import org.apache.catalina.tribes.util.TcclThreadFactory;

public class MessageDispatch15Interceptor
extends MessageDispatchInterceptor {
    protected final AtomicLong currentSize = new AtomicLong(0L);
    protected ExecutorService executor = null;
    protected int maxThreads = 10;
    protected int maxSpareThreads = 2;
    protected long keepAliveTime = 5000L;

    @Override
    public long getCurrentSize() {
        return this.currentSize.get();
    }

    @Override
    public long addAndGetCurrentSize(long inc) {
        return this.currentSize.addAndGet(inc);
    }

    @Override
    public long setAndGetCurrentSize(long value) {
        this.currentSize.set(value);
        return value;
    }

    @Override
    public boolean addToQueue(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        final LinkObject obj = new LinkObject(msg, destination, payload);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MessageDispatch15Interceptor.this.sendAsyncData(obj);
            }
        };
        this.executor.execute(r);
        return true;
    }

    @Override
    public LinkObject removeFromQueue() {
        return null;
    }

    @Override
    public void startQueue() {
        if (this.run) {
            return;
        }
        this.executor = ExecutorFactory.newThreadPool(this.maxSpareThreads, this.maxThreads, this.keepAliveTime, TimeUnit.MILLISECONDS, new TcclThreadFactory("MessageDispatch15Interceptor.MessageDispatchThread"));
        this.run = true;
    }

    @Override
    public void stopQueue() {
        this.run = false;
        this.executor.shutdownNow();
        this.setAndGetCurrentSize(0L);
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }
}

