/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CFClientV1Support;
import org.eclipse.cft.server.core.internal.client.diego.CloudInfoSsh;
import org.eclipse.cft.server.core.internal.ssh.SshHost;
import org.eclipse.core.runtime.CoreException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SshClientSupport
extends CFClientV1Support {
    private String sshClientId;

    public SshClientSupport(CloudFoundryOperations cfClient, CloudInfoSsh cloudInfo, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSigned) {
        super(cfClient, null, cloudInfo, httpProxyConfiguration, trustSelfSigned);
        this.sshClientId = cloudInfo.getSshClientId();
    }

    public String getSshCode() {
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(this.authorizationUrl) + "/oauth/authorize");
            builder.addParameter("response_type", "code");
            builder.addParameter("grant_type", "authorization_code");
            builder.addParameter("client_id", this.sshClientId);
            URI url = new URI(builder.toString());
            ResponseEntity response = this.restTemplate.getForEntity(url, String.class);
            HttpStatus statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.FOUND) {
                throw new CloudFoundryException(statusCode);
            }
            String loc = response.getHeaders().getFirst("Location");
            if (loc == null) {
                throw new CloudOperationException("No 'Location' header in redirect response");
            }
            List qparams = URLEncodedUtils.parse((URI)new URI(loc), (String)"utf8");
            for (NameValuePair pair : qparams) {
                String name = pair.getName();
                if (!name.equals("code")) continue;
                return pair.getValue();
            }
            throw new CloudOperationException("No 'code' param in redirect Location: " + loc);
        }
        catch (URISyntaxException e) {
            throw new CloudOperationException((Throwable)e);
        }
    }

    public SshHost getSshHost() {
        return this.getCloudInfo().getSshHost();
    }

    public static SshClientSupport create(CloudFoundryOperations client, CloudInfoSsh cloudInfo, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        return new SshClientSupport(client, cloudInfo, proxyConf, selfSigned);
    }

    public Session connect(CloudApplication app, CloudFoundryServer cloudServer, int appInstance) throws CoreException {
        JSch jsch = new JSch();
        String user = "cf:" + app.getMeta().getGuid().toString() + "/" + appInstance;
        String oneTimeCode = null;
        try {
            Session session = jsch.getSession(user, this.getSshHost().getHost(), this.getSshHost().getPort());
            oneTimeCode = this.getSshCode();
            session.setPassword(oneTimeCode);
            session.setUserInfo(this.getUserInfo(oneTimeCode));
            session.setServerAliveInterval(15000);
            session.connect();
            return session;
        }
        catch (JSchException e) {
            throw CloudErrorUtil.asCoreException("SSH connection error " + e.getMessage(), e, false);
        }
    }

    @Override
    protected CloudInfoSsh getCloudInfo() {
        return (CloudInfoSsh)super.getCloudInfo();
    }

    protected UserInfo getUserInfo(final String accessToken) {
        return new UserInfo(){

            public void showMessage(String arg0) {
            }

            public boolean promptYesNo(String arg0) {
                return true;
            }

            public boolean promptPassword(String arg0) {
                return true;
            }

            public boolean promptPassphrase(String arg0) {
                return false;
            }

            public String getPassword() {
                return accessToken;
            }

            public String getPassphrase() {
                return null;
            }
        };
    }
}

