/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class ServerCredentialsStore {
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_USERNAME = "username";
    private boolean initialized;
    private String password;
    private AtomicBoolean securePreferencesDisabled = new AtomicBoolean(false);
    private String serverId;
    private String username;
    private final String nodeId;

    public ServerCredentialsStore(String serverId) {
        this(serverId, "org.eclipse.cft.server.core");
    }

    protected ServerCredentialsStore(String serverId, String nodeId) {
        this.serverId = serverId;
        this.nodeId = nodeId;
    }

    public boolean flush(String newServerId) {
        ISecurePreferences preferences;
        String oldServerId = this.getServerId();
        if (oldServerId != null && !oldServerId.equals(newServerId)) {
            this.initialize();
            preferences = this.getSecurePreferences();
            if (preferences != null) {
                preferences.removeNode();
            }
        }
        this.serverId = newServerId;
        preferences = this.getSecurePreferences();
        if (preferences != null) {
            try {
                preferences.put(KEY_USERNAME, this.username, true);
                preferences.put(KEY_PASSWORD, this.password, true);
                return true;
            }
            catch (StorageException e) {
                this.disableSecurePreferences(e);
            }
        }
        return false;
    }

    public String getPassword() {
        this.initialize();
        return this.password;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getUsername() {
        this.initialize();
        return this.username;
    }

    public void setPassword(String password) {
        this.initialize();
        this.password = password;
    }

    public void setUsername(String username) {
        this.initialize();
        this.username = username;
    }

    private void disableSecurePreferences(StorageException e) {
        if (!this.securePreferencesDisabled.getAndSet(true)) {
            CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", "Unexpected error while accessing secure preferences for server: " + this.serverId));
        }
    }

    private ISecurePreferences getSecurePreferences() {
        String serverId;
        if (!this.securePreferencesDisabled.get() && (serverId = this.getServerId()) != null) {
            ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault().node(this.nodeId);
            securePreferences = securePreferences.node(EncodingUtils.encodeSlashes((String)serverId));
            return securePreferences;
        }
        return null;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.username = this.readProperty(KEY_USERNAME);
        this.password = this.readProperty(KEY_PASSWORD);
    }

    private String readProperty(String property) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences != null) {
            try {
                return preferences.get(property, null);
            }
            catch (StorageException e) {
                this.disableSecurePreferences(e);
            }
        }
        return null;
    }
}

