/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.util.CloudEntityResourceMapper;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.AuthorizationHeaderProvider;
import org.eclipse.cft.server.core.internal.client.V1ClientSupport;
import org.eclipse.cft.server.core.internal.client.v2.CloudInfoV2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class BuildpackSupport
extends V1ClientSupport {
    public BuildpackSupport(AuthorizationHeaderProvider oauth, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        super(oauth, cloudInfo, trustSelfSigned, httpProxyConfiguration);
    }

    public List<String> getBuildpacks() {
        List newResources;
        Map resource;
        ArrayList<String> buildpacks = new ArrayList<String>();
        String json = (String)this.restTemplate.getForObject(this.url("/v2/buildpacks"), String.class, new Object[0]);
        if (json != null && (resource = JsonUtil.convertJsonToMap((String)json)) != null && (newResources = (List)resource.get("resources")) != null) {
            for (Map res : newResources) {
                String name = (String)CloudEntityResourceMapper.getEntityAttribute((Map)res, (String)"name", String.class);
                if (name == null) continue;
                buildpacks.add(name);
            }
        }
        return buildpacks;
    }

    public static BuildpackSupport create(CloudFoundryServer cloudServer, CloudFoundryOperations client, IProgressMonitor monitor) throws CoreException {
        String userName = cloudServer.getUsername();
        String password = cloudServer.getPassword();
        boolean selfSigned = cloudServer.getSelfSignedCertificate();
        final CloudFoundryOperations cfClient = client;
        HttpProxyConfiguration proxyConf = null;
        AuthorizationHeaderProvider oauth = new AuthorizationHeaderProvider(){

            @Override
            public String getAuthorizationHeader() {
                OAuth2AccessToken token = cfClient.login();
                return String.valueOf(token.getTokenType()) + " " + token.getValue();
            }
        };
        CloudInfoV2 cloudInfo = new CloudInfoV2(new CloudCredentials(userName, password), client.getCloudControllerUrl().toString(), proxyConf, selfSigned);
        return new BuildpackSupport(oauth, cloudInfo, selfSigned, proxyConf);
    }
}

