/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.policies;

import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.policies.ContainerHighlightEditPolicy;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class FlowHighlightEditPolicy
extends ContainerHighlightEditPolicy {
    private Polyline insertionLine = null;
    private Polyline insertionLine2 = null;
    private IFigure feedbackfig = null;
    private Point translatedPt;
    protected int selectedState = -1;

    public FlowHighlightEditPolicy(boolean resizable) {
        super(resizable, true);
    }

    private Point translateToRelativePoint(Point pt) {
        Point newpt = pt.getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)newpt);
        ((GraphicalEditPart)this.getHost().getRoot()).getFigure().translateToAbsolute((Translatable)newpt);
        return newpt;
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        if (this.insertionLine != null) {
            this.insertionLine = null;
            this.insertionLine2 = null;
        }
        if (this.feedbackfig != null) {
            this.removeFeedback(this.feedbackfig);
            this.feedbackfig = null;
        }
    }

    @Override
    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if ((request.getType().equals("add children") || request.getType().equals("create child")) && ((BPELEditPart)this.getHost()).canExecuteRequest(request)) {
            this.showHighlight(request);
        }
    }

    protected void showHighlight(Request request) {
        Point p = null;
        if (request instanceof ChangeBoundsRequest) {
            p = ((ChangeBoundsRequest)request).getLocation().getCopy();
        } else if (request instanceof CreateRequest) {
            p = ((CreateRequest)request).getLocation().getCopy();
        }
        if (p != null) {
            IFigure oldfeedback = this.feedbackfig;
            if (this.feedbackfig != null) {
                this.removeFeedback(this.feedbackfig);
            }
            if (request instanceof CreateRequest && this.feedbackfig != null) {
                oldfeedback.translate(-this.translatedPt.x, -this.translatedPt.y);
            }
            this.insertionLine = new Polyline();
            this.insertionLine.setLineWidth(1);
            this.insertionLine.setOutlineXOR(true);
            this.insertionLine.setForegroundColor(ColorConstants.darkGray);
            this.insertionLine2 = new Polyline();
            this.insertionLine2.setLineWidth(1);
            this.insertionLine2.setOutlineXOR(true);
            this.insertionLine2.setForegroundColor(ColorConstants.darkGray);
            this.insertionLine.addPoint(this.translateToRelativePoint(new Point(p.x, p.y - 25)));
            this.insertionLine.addPoint(this.translateToRelativePoint(new Point(p.x, p.y + 25)));
            this.insertionLine2.addPoint(this.translateToRelativePoint(new Point(p.x - 25, p.y)));
            this.insertionLine2.addPoint(this.translateToRelativePoint(new Point(p.x + 25, p.y)));
            if (request instanceof CreateRequest && this.feedbackfig != null) {
                this.translatedPt = this.translateToRelativePoint(new Point(p.x, p.y));
                oldfeedback.translate(this.translatedPt.x, this.translatedPt.y);
                this.addFeedback(oldfeedback);
            }
        }
    }

    protected void setSelectedState(int type) {
        this.selectedState = type;
        super.setSelectedState(type);
    }

    public void setResizable(boolean resizable) {
        this.fResizable = resizable;
        if (this.selectedState != -1) {
            int previousState = this.selectedState;
            this.setSelectedState(-1);
            this.setSelectedState(previousState);
        }
    }
}

