/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.details;

import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class ChangeHelper
implements IOngoingChange,
Listener {
    protected ICommandFramework fCommandFramework;
    protected int fNonUserChange = 0;

    public void startNonUserChange() {
        ++this.fNonUserChange;
    }

    public void finishNonUserChange() {
        if (this.fNonUserChange == 0) {
            throw new IllegalStateException("Non-matching call to finishNonUserChange()");
        }
        --this.fNonUserChange;
    }

    public boolean isNonUserChange() {
        return this.fNonUserChange > 0;
    }

    public ChangeHelper(ICommandFramework commandFramework) {
        this.fCommandFramework = commandFramework;
    }

    public void handleEvent(Event event) {
        if (this.isNonUserChange()) {
            return;
        }
        switch (event.type) {
            case 1: {
                if (event.character != '\r') break;
                this.finish();
                break;
            }
            case 16: {
                this.finish();
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                this.modify();
                break;
            }
            case 12: {
                this.abort();
            }
        }
    }

    void finish() {
        this.fCommandFramework.notifyChangeDone(this);
    }

    void modify() {
        this.fCommandFramework.notifyChangeInProgress(this);
    }

    void abort() {
        this.fCommandFramework.abortCurrentChange();
    }

    protected boolean isModifyBasedControl(Control c) {
        if (c instanceof CCombo) {
            return (c.getStyle() & 8) == 0;
        }
        return c instanceof Text;
    }

    protected boolean isSelectionBasedControl(Control c) {
        return !(c instanceof Text);
    }

    public void startListeningTo(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addListener(16, (Listener)this);
            control.addListener(12, (Listener)this);
            if (this.isModifyBasedControl(control)) {
                control.addListener(24, (Listener)this);
            }
            if (this.isSelectionBasedControl(control)) {
                control.addListener(13, (Listener)this);
                control.addListener(14, (Listener)this);
            }
            ++n2;
        }
    }

    public void startListeningForEnter(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addListener(1, (Listener)this);
            ++n2;
        }
    }

    public void stopListeningTo(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.removeListener(16, (Listener)this);
            if (this.isModifyBasedControl(control)) {
                control.removeListener(24, (Listener)this);
            }
            if (this.isSelectionBasedControl(control)) {
                control.removeListener(13, (Listener)this);
                control.removeListener(14, (Listener)this);
            }
            control.removeListener(1, (Listener)this);
            ++n2;
        }
    }
}

