/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.tcp;

import com.digitalpetri.netty.fsm.ChannelFsm;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.AbstractTransport;
import org.eclipse.milo.opcua.stack.client.transport.UaTransport;
import org.eclipse.milo.opcua.stack.client.transport.uasc.ClientChannelFsm;

public class OpcTcpTransport
extends AbstractTransport
implements UaTransport {
    private final ChannelFsm channelFsm;
    private final UaStackClient client;

    public OpcTcpTransport(UaStackClient client) {
        super(client.getConfig());
        this.client = client;
        this.channelFsm = ClientChannelFsm.newChannelFsm(client);
    }

    @Override
    public UaStackClientConfig getConfig() {
        return this.client.getConfig();
    }

    @Override
    public CompletableFuture<UaTransport> connect() {
        return this.channelFsm.connect().thenApply(v -> this);
    }

    @Override
    public CompletableFuture<UaTransport> disconnect() {
        return this.channelFsm.disconnect().thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Channel> channel() {
        return this.channelFsm.getChannel();
    }

    public ChannelFsm channelFsm() {
        return this.channelFsm;
    }
}

