/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class BatikHistogramNormalizationElementBridge
extends AbstractSVGFilterPrimitiveElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "histogramNormalization";
    }

    public Bridge getInstance() {
        return new BatikHistogramNormalizationElementBridge();
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        Filter in = BatikHistogramNormalizationElementBridge.getIn((Element)filterElement, (Element)filteredElement, (GraphicsNode)filteredNode, (Filter)inputFilter, (Map)filterMap, (BridgeContext)ctx);
        if (in == null) {
            return null;
        }
        Filter sourceGraphics = (Filter)filterMap.get("SourceGraphic");
        Rectangle2D defaultRegion = in == sourceGraphics ? filterRegion : in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion((Element)filterElement, (Element)filteredElement, (GraphicsNode)filteredNode, (Rectangle2D)defaultRegion, (Rectangle2D)filterRegion, (BridgeContext)ctx);
        float trim = 1.0f;
        String s = filterElement.getAttributeNS(null, "trim");
        if (s.length() != 0) {
            try {
                trim = SVGUtilities.convertSVGNumber((String)s);
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{"trim", s});
            }
        }
        if (trim < 0.0f) {
            trim = 0.0f;
        } else if (trim > 100.0f) {
            trim = 100.0f;
        }
        Object filter = in;
        filter = new BatikHistogramNormalizationFilter8Bit((Filter)filter, trim / 100.0f);
        filter = new PadRable8Bit(filter, primitiveRegion, PadMode.ZERO_PAD);
        BatikHistogramNormalizationElementBridge.updateFilterMap((Element)filterElement, (Filter)filter, (Map)filterMap);
        BatikHistogramNormalizationElementBridge.handleColorInterpolationFilters((Filter)filter, (Element)filterElement);
        return filter;
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s = filterElement.getAttributeNS(null, attrName);
        if (s.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger((String)s);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{attrName, s});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s});
        }
        return ret;
    }
}

