/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.slf4j.Logger;

public class Threads {
    private static final String FORMAT = "\"${name}\"${isDaemon} prio=${priority} tid=${threadIdDec} state=${state} ";

    private Threads() {
    }

    public static void dumpAllThreads(Logger logger) {
        Args.notNull(logger, "logger");
        if (!logger.isWarnEnabled()) {
            return;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        StringBuilder dump = new StringBuilder();
        dump.append("Full thread dump ").append(runtimeMXBean.getVmName()).append('(').append(runtimeMXBean.getVmVersion()).append(')');
        logger.warn(dump.toString());
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            Threads.dumpSingleThread(logger, entry.getKey(), entry.getValue());
        }
    }

    public static void dumpSingleThread(Logger logger, Thread thread) {
        Args.notNull(logger, "logger");
        if (!logger.isWarnEnabled()) {
            return;
        }
        Threads.dumpSingleThread(logger, thread, thread.getStackTrace());
    }

    private static void dumpSingleThread(Logger logger, Thread thread, StackTraceElement[] trace) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("name", thread.getName());
        variables.put("isDaemon", thread.isDaemon() ? " daemon" : "");
        variables.put("priority", thread.getPriority());
        variables.put("threadIdDec", thread.getId());
        variables.put("state", (Object)thread.getState());
        ThreadDump throwable = new ThreadDump();
        throwable.setStackTrace(trace);
        logger.warn(MapVariableInterpolator.interpolate(FORMAT, variables), throwable);
    }

    private static class ThreadDump
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private ThreadDump() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

