/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeSystemDescriptionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TypeSystemDescriptionFactory.class);
    private static final Object SCAN_LOCK = new Object();
    private static final Object CREATE_LOCK = new Object();
    private static WeakHashMap<ClassLoader, String[]> typeDescriptorLocationsByClassloader = new WeakHashMap();
    private static WeakHashMap<ClassLoader, TypeSystemDescription> typeDescriptorByClassloader = new WeakHashMap();

    private TypeSystemDescriptionFactory() {
    }

    public static TypeSystemDescription createTypeSystemDescription(String ... descriptorNames) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeSystemDescription createTypeSystemDescription() throws ResourceInitializationException {
        ClassLoader cl = ClassLoaderUtils.findClassloader();
        TypeSystemDescription tsd = typeDescriptorByClassloader.get(cl);
        if (tsd == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
                for (String location : TypeSystemDescriptionFactory.scanTypeDescriptors()) {
                    try {
                        XMLInputSource xmlInputType1 = new XMLInputSource(location);
                        tsdList.add(UIMAFramework.getXMLParser().parseTypeSystemDescription(xmlInputType1));
                        LOG.debug("Detected type system at [{}]", (Object)location);
                    }
                    catch (IOException e) {
                        throw new ResourceInitializationException((Throwable)e);
                    }
                    catch (InvalidXMLException e) {
                        LOG.warn("[{}] is not a type file. Ignoring.", (Object)location, (Object)e);
                    }
                }
                ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
                tsd = CasCreationUtils.mergeTypeSystems(tsdList, (ResourceManager)resMgr);
                typeDescriptorByClassloader.put(cl, tsd);
            }
        }
        return (TypeSystemDescription)tsd.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypeDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            String[] typeDescriptorLocations = typeDescriptorLocationsByClassloader.get(cl);
            if (typeDescriptorLocations == null) {
                typeDescriptorLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_SYSTEM);
                typeDescriptorLocationsByClassloader.put(cl, typeDescriptorLocations);
            }
            return typeDescriptorLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceTypeDescriptorsScan() {
        Object object = SCAN_LOCK;
        synchronized (object) {
            typeDescriptorLocationsByClassloader.clear();
            typeDescriptorByClassloader.clear();
        }
    }
}

