/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class TryCatchStatement
extends Statement {
    public static final TokenRole TRY_KEYWORD_ROLE = new TokenRole("try", 1);
    public static final Role<BlockStatement> TRY_BLOCK_ROLE = new Role<BlockStatement>("TryBlock", BlockStatement.class, BlockStatement.NULL);
    public static final Role<CatchClause> CATCH_CLAUSE_ROLE = new Role<CatchClause>("CatchClause", CatchClause.class);
    public static final TokenRole FINALLY_KEYWORD_ROLE = new TokenRole("finally", 1);
    public static final Role<BlockStatement> FINALLY_BLOCK_ROLE = new Role<BlockStatement>("FinallyBlock", BlockStatement.class, BlockStatement.NULL);
    public static final Role<VariableDeclarationStatement> TRY_RESOURCE_ROLE = new Role<VariableDeclarationStatement>("TryResource", VariableDeclarationStatement.class);

    public TryCatchStatement(int offset) {
        super(offset);
    }

    public final JavaTokenNode getTryToken() {
        return this.getChildByRole(TRY_KEYWORD_ROLE);
    }

    public final JavaTokenNode getFinallyToken() {
        return this.getChildByRole(FINALLY_KEYWORD_ROLE);
    }

    public final AstNodeCollection<CatchClause> getCatchClauses() {
        return this.getChildrenByRole(CATCH_CLAUSE_ROLE);
    }

    public final AstNodeCollection<VariableDeclarationStatement> getResources() {
        return this.getChildrenByRole(TRY_RESOURCE_ROLE);
    }

    public final BlockStatement getTryBlock() {
        return this.getChildByRole(TRY_BLOCK_ROLE);
    }

    public final void setTryBlock(BlockStatement value) {
        this.setChildByRole(TRY_BLOCK_ROLE, value);
    }

    public final BlockStatement getFinallyBlock() {
        return this.getChildByRole(FINALLY_BLOCK_ROLE);
    }

    public final void setFinallyBlock(BlockStatement value) {
        this.setChildByRole(FINALLY_BLOCK_ROLE, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitTryCatchStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof TryCatchStatement) {
            TryCatchStatement otherStatement = (TryCatchStatement)other;
            return !otherStatement.isNull() && this.getTryBlock().matches(otherStatement.getTryBlock(), match) && this.getCatchClauses().matches(otherStatement.getCatchClauses(), match) && this.getFinallyBlock().matches(otherStatement.getFinallyBlock(), match);
        }
        return false;
    }
}

