/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.dictionaryResource;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;

public class DictionaryToken {
    private String text;
    private Integer type;
    private String tokenClass;
    private boolean tokenTypeFeatureDefined;
    private boolean tokenClassFeatureDefined;

    public DictionaryToken(AnnotationFS annotation, Feature tokenTypeFeature, Feature tokenClassFeature) {
        if (tokenTypeFeature == null) {
            this.setTokenTypeFeatureDefined(false);
        } else {
            this.setTokenTypeFeatureDefined(true);
            this.setType(annotation.getIntValue(tokenTypeFeature));
        }
        if (tokenClassFeature == null) {
            this.setTokenClassFeatureDefined(false);
        } else {
            this.setTokenClassFeatureDefined(true);
            this.setTokenClass(annotation.getStringValue(tokenClassFeature));
        }
        this.setText(annotation.getCoveredText());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTokenClass() {
        return this.tokenClass;
    }

    public void setTokenClass(String tokenClass) {
        this.tokenClass = tokenClass;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean isTokenTypeFeatureDefined() {
        return this.tokenTypeFeatureDefined;
    }

    public void setTokenTypeFeatureDefined(boolean tokenTypeFeatureDefined) {
        this.tokenTypeFeatureDefined = tokenTypeFeatureDefined;
    }

    public boolean isTokenClassFeatureDefined() {
        return this.tokenClassFeatureDefined;
    }

    public void setTokenClassFeatureDefined(boolean tokenClassFeatureDefined) {
        this.tokenClassFeatureDefined = tokenClassFeatureDefined;
    }
}

