/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.extensions.IRutaExtension;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.verbalize.ActionVerbalizer;
import org.apache.uima.ruta.verbalize.ConditionVerbalizer;
import org.apache.uima.ruta.verbalize.ExpressionVerbalizer;
import org.apache.uima.ruta.verbalize.ScriptVerbalizer;
import org.apache.uima.ruta.verbalize.VerbalizerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaVerbalizer {
    private Map<Class<?>, IRutaExtension> externalVerbalizers = new HashMap();
    private ActionVerbalizer actionVerbalizer = new ActionVerbalizer(this);
    private ConditionVerbalizer conditionVerbalizer = new ConditionVerbalizer(this);
    private ExpressionVerbalizer expressionVerbalizer = new ExpressionVerbalizer(this);
    private ScriptVerbalizer scriptVerbalizer = new ScriptVerbalizer(this);
    private VerbalizerUtils verbalizerUtils = new VerbalizerUtils(this);

    public void addExternalVerbalizers(IRutaExtension verbalizer) {
        Class<?>[] extensions;
        for (Class<?> eachClass : extensions = verbalizer.extensions()) {
            this.externalVerbalizers.put(eachClass, verbalizer);
        }
    }

    public String verbalize(RutaElement element) {
        if (this.externalVerbalizers.keySet().contains(element.getClass())) {
            return this.externalVerbalizers.get(element.getClass()).verbalize(element, this);
        }
        if (element instanceof AbstractRutaAction) {
            return this.actionVerbalizer.verbalize((AbstractRutaAction)element);
        }
        if (element instanceof AbstractRutaCondition) {
            return this.conditionVerbalizer.verbalize((AbstractRutaCondition)element);
        }
        if (element instanceof RutaExpression) {
            return this.expressionVerbalizer.verbalize((RutaExpression)element);
        }
        return this.scriptVerbalizer.verbalize(element);
    }

    public String verbalizeName(RutaElement element) {
        if (this.externalVerbalizers.keySet().contains(element.getClass())) {
            return this.externalVerbalizers.get(element.getClass()).verbalizeName(element);
        }
        if (element instanceof AbstractRutaAction) {
            return this.actionVerbalizer.verbalizeName((AbstractRutaAction)element);
        }
        if (element instanceof AbstractRutaCondition) {
            return this.conditionVerbalizer.verbalizeName((AbstractRutaCondition)element);
        }
        return element.getClass().getSimpleName();
    }

    public String verbalize(RutaBlock block, boolean withElements) {
        return this.scriptVerbalizer.verbalizeBlock(block, withElements);
    }

    public String verbalize(RuleElement element) {
        return this.scriptVerbalizer.verbalizeRuleElement(element);
    }

    public String verbalizeType(Type type) {
        if (type.getName().equals("uima.tcas.DocumentAnnotation")) {
            return "Document";
        }
        return type.getShortName();
    }

    public String verbalizeList(List<?> list) {
        return this.verbalizerUtils.verbalizeList(list);
    }

    public String verbalizeTypeList(List<Type> list) {
        return this.verbalizerUtils.verbalizeTypeList(list);
    }

    public String verbalizeExpressionList(List<? extends RutaExpression> list) {
        return this.verbalizerUtils.verbalizeExpressionList(list);
    }

    public String verbalizeMatcher(RutaRuleElement tmre) {
        return this.scriptVerbalizer.verbalizeMatcher(tmre);
    }

    public String verbalizeComposed(ComposedRuleElement cre) {
        return this.scriptVerbalizer.verbalizeComposed(cre);
    }
}

