/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule.quantifier;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxReluctant
implements RuleElementQuantifier {
    private NumberExpression min;
    private NumberExpression max;

    public MinMaxReluctant(NumberExpression min, NumberExpression max, boolean interval) {
        if (!interval) {
            this.min = min;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
            if (this.max == null) {
                this.max = new SimpleNumberExpression(Integer.MAX_VALUE);
            }
        }
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    @Override
    public List<RuleElementMatch> evaluateMatches(List<RuleElementMatch> matches, RutaStatement element, InferenceCrowd crowd) {
        int matchedSize;
        boolean result;
        RuleElementMatch ruleElementMatch;
        int minValue = this.min.getIntegerValue(element.getParent());
        int maxValue = this.max.getIntegerValue(element.getParent());
        if (matches.size() > 0 && !(ruleElementMatch = matches.get(matches.size() - 1)).matched()) {
            matches.remove(ruleElementMatch);
        }
        boolean bl = result = (matchedSize = matches.size()) >= minValue && matchedSize <= maxValue;
        if (result) {
            return matches;
        }
        return null;
    }

    @Override
    public boolean continueMatch(boolean after, AnnotationFS annotation, RuleElement ruleElement, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, RutaStream stream, InferenceCrowd crowd) {
        int minValue = this.min.getIntegerValue(ruleElement.getParent());
        int maxValue = this.max.getIntegerValue(ruleElement.getParent());
        List<RuleElementMatch> list = containerMatch.getInnerMatches().get(ruleElement);
        if (list == null && maxValue > 0) {
            return true;
        }
        int matchedSize = list.size();
        if (list == null || list.isEmpty() || matchedSize < minValue) {
            return true;
        }
        RuleElementMatch lastMatch = null;
        lastMatch = after ? list.get(list.size() - 1) : list.get(0);
        RuleElement nextElement = ruleElement.getContainer().getNextElement(after, ruleElement);
        if (nextElement == null) {
            return false;
        }
        ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
        RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch);
        nextElement.continueMatch(after, annotation, extendedMatch, null, extendedContainerMatch, null, nextElement, stream, crowd);
        List<RuleElementMatch> nextList = extendedContainerMatch.getInnerMatches().get(nextElement);
        boolean nextMatched = nextList != null && !nextList.isEmpty();
        return matchedSize < maxValue && matchedSize >= minValue && !nextMatched || !lastMatch.matched() && matchedSize >= minValue && matchedSize <= maxValue && !nextMatched;
    }

    @Override
    public boolean isOptional(RutaBlock parent) {
        int minValue = this.min.getIntegerValue(parent);
        return minValue == 0;
    }
}

