/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.BooleanNumberExpression;
import org.apache.uima.ruta.expression.bool.BooleanTypeExpression;
import org.apache.uima.ruta.expression.bool.ReferenceBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanFunction;
import org.apache.uima.ruta.expression.list.BooleanListExpression;
import org.apache.uima.ruta.expression.list.NumberListExpression;
import org.apache.uima.ruta.expression.list.ReferenceBooleanListExpression;
import org.apache.uima.ruta.expression.list.ReferenceNumberListExpression;
import org.apache.uima.ruta.expression.list.ReferenceStringListExpression;
import org.apache.uima.ruta.expression.list.ReferenceTypeListExpression;
import org.apache.uima.ruta.expression.list.SimpleBooleanListExpression;
import org.apache.uima.ruta.expression.list.SimpleNumberListExpression;
import org.apache.uima.ruta.expression.list.SimpleStringListExpression;
import org.apache.uima.ruta.expression.list.SimpleTypeListExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.number.ComposedNumberExpression;
import org.apache.uima.ruta.expression.number.NegativeNumberExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.ReferenceNumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordListExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordTableExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordListExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordTableExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.ComposedStringExpression;
import org.apache.uima.ruta.expression.string.ReferenceStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.ReferenceTypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactory {
    private ExpressionFactory() {
    }

    public static NumberExpression createIntegerExpression(Token number, Token minus) {
        Integer valueOf = Integer.valueOf(number.getText());
        SimpleNumberExpression simpleNumberExpression = new SimpleNumberExpression(valueOf);
        if (minus != null) {
            return new NegativeNumberExpression(simpleNumberExpression);
        }
        return simpleNumberExpression;
    }

    public static NumberExpression createDoubleExpression(Token number, Token minus) {
        Double valueOf = Double.valueOf(number.getText());
        SimpleNumberExpression simpleNumberExpression = new SimpleNumberExpression(valueOf);
        if (minus != null) {
            return new NegativeNumberExpression(simpleNumberExpression);
        }
        return simpleNumberExpression;
    }

    public static NumberExpression createReferenceNumberExpression(Token var, Token minus) {
        ReferenceNumberExpression simpleNumberExpression = new ReferenceNumberExpression(var.getText());
        if (minus != null) {
            return new NegativeNumberExpression(simpleNumberExpression);
        }
        return simpleNumberExpression;
    }

    public static NumberExpression createComposedNumberExpression(List<NumberExpression> expressions, List<Token> opTokens) {
        ArrayList<String> ops = new ArrayList<String>();
        for (Token token : opTokens) {
            ops.add(token.getText());
        }
        return new ComposedNumberExpression(expressions, ops);
    }

    public static NumberExpression createComposedNumberExpression(NumberExpression expression, Token opToken) {
        ArrayList<String> ops = new ArrayList<String>();
        ArrayList<NumberExpression> exprList = new ArrayList<NumberExpression>();
        ops.add(opToken.getText());
        exprList.add(expression);
        return new ComposedNumberExpression(exprList, ops);
    }

    public static StringExpression createSimpleStringExpression(Token token) {
        String text = token.getText();
        String substring = text.substring(1, text.length() - 1);
        return new SimpleStringExpression(substring);
    }

    public static StringExpression createComposedStringExpression(List<StringExpression> expressions) {
        return new ComposedStringExpression(expressions);
    }

    public static StringExpression createReferenceStringExpression(Token var) {
        return new ReferenceStringExpression(var.getText());
    }

    public static BooleanExpression createBooleanNumberExpression(NumberExpression e1, Token op, NumberExpression e2) {
        return new BooleanNumberExpression(e1, op.getText(), e2);
    }

    public static BooleanExpression createSimpleBooleanExpression(Token v) {
        return new SimpleBooleanExpression(Boolean.valueOf(v.getText()));
    }

    public static BooleanExpression createReferenceBooleanExpression(Token id) {
        return new ReferenceBooleanExpression(id.getText());
    }

    public static TypeExpression createSimpleTypeExpression(Token typeToken, RutaBlock parent) {
        String typeString = typeToken == null ? "uima.tcas.DocumentAnnotation" : typeToken.getText();
        return new SimpleTypeExpression(typeString);
    }

    public static TypeExpression createReferenceTypeExpression(Token varToken) {
        String varString = varToken == null ? "" : varToken.getText();
        return new ReferenceTypeExpression(varString);
    }

    public static TypeExpression createSimpleTypeExpression(String typeString, RutaBlock parent) {
        return new SimpleTypeExpression(typeString);
    }

    public static BooleanExpression createBooleanFunction(Token op, BooleanExpression e1, BooleanExpression e2) {
        return new SimpleBooleanFunction(op.getText(), e1, e2);
    }

    public static WordTableExpression createReferenceWordTableExpression(Token id) {
        return new ReferenceWordTableExpression(id.getText());
    }

    public static WordListExpression createReferenceWordListExpression(Token id) {
        return new ReferenceWordListExpression(id.getText());
    }

    public static WordListExpression createLiteralWordListExpression(Token path) {
        return new LiteralWordListExpression(path.getText());
    }

    public static WordTableExpression createLiteralWordTableExpression(Token path) {
        return new LiteralWordTableExpression(path.getText());
    }

    public static BooleanExpression createBooleanTypeExpression(TypeExpression e1, Token op, TypeExpression e2) {
        return new BooleanTypeExpression(e1, op.getText(), e2);
    }

    public static BooleanListExpression createReferenceBooleanListExpression(Token var) {
        return new ReferenceBooleanListExpression(var.getText());
    }

    public static StringListExpression createReferenceStringListExpression(Token var) {
        return new ReferenceStringListExpression(var.getText());
    }

    public static TypeListExpression createReferenceTypeListExpression(Token var) {
        return new ReferenceTypeListExpression(var.getText());
    }

    public static NumberListExpression createReferenceDoubleListExpression(Token var) {
        return new ReferenceNumberListExpression(var.getText());
    }

    public static NumberListExpression createReferenceIntListExpression(Token var) {
        return new ReferenceNumberListExpression(var.getText());
    }

    public static NumberListExpression createReferenceFloatListExpression(Token var) {
        return new ReferenceNumberListExpression(var.getText());
    }

    public static BooleanListExpression createBooleanListExpression(List<BooleanExpression> list) {
        return new SimpleBooleanListExpression(list);
    }

    public static NumberListExpression createNumberListExpression(List<NumberExpression> list) {
        return new SimpleNumberListExpression(list);
    }

    public static TypeListExpression createTypeListExpression(List<TypeExpression> list) {
        return new SimpleTypeListExpression(list);
    }

    public static StringListExpression createStringListExpression(List<StringExpression> list) {
        return new SimpleStringListExpression(list);
    }
}

