/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class AssignAction
extends AbstractRutaAction {
    private String var;
    private RutaExpression expression;

    public AssignAction(String var, RutaExpression e) {
        this.var = var;
        this.expression = e;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaBlock parent = element.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Class<?> clazz = environment.getVariableType(this.var);
        if (clazz.equals(Integer.class) && this.expression instanceof NumberExpression) {
            int v = ((NumberExpression)this.expression).getIntegerValue(parent);
            environment.setVariableValue(this.var, v);
        } else if (clazz.equals(Double.class) && this.expression instanceof NumberExpression) {
            double v = ((NumberExpression)this.expression).getDoubleValue(parent);
            environment.setVariableValue(this.var, v);
        } else if (clazz.equals(Type.class) && this.expression instanceof TypeExpression) {
            Type v = ((TypeExpression)this.expression).getType(parent);
            environment.setVariableValue(this.var, v);
        } else if (clazz.equals(Boolean.class) && this.expression instanceof BooleanExpression) {
            boolean v = ((BooleanExpression)this.expression).getBooleanValue(parent);
            environment.setVariableValue(this.var, v);
        } else if (clazz.equals(String.class) && this.expression instanceof StringExpression) {
            String v = ((StringExpression)this.expression).getStringValue(parent);
            environment.setVariableValue(this.var, v);
        }
    }

    public String getVar() {
        return this.var;
    }

    public RutaExpression getExpression() {
        return this.expression;
    }
}

