package org.apache.stratum.ojb;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.exception.NestableException;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Initializable;

/**
 * This class is the Object Bridege component that
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: OJBComponent.java 264191 2005-08-29 18:07:52Z henning $
 */
public class OJBComponent
        implements Configurable, Initializable
{
    /** TODO: DOCUMENT ME! */
    private PersistenceBroker pBroker = null;

    /** The location of the OJB properties file */
    private String propLocation;

    /** The location of the OJB repository file */
    private String repositoryLocation;

    /**
     * Configure the Broker
     *
     * @param configuration TODO: DOCUMENT ME!
     *
     * @throws NestableException TODO: DOCUMENT ME!
     */
    public void configure(Configuration configuration)
            throws NestableException
    {
        propLocation = configuration.getString("ojb.properties.location");
        repositoryLocation = configuration.getString("ojb.repository.location");
    }

    /**
     * Initialize the OJB Broker
     *
     * @throws Exception TODO: DOCUMENT ME!
     */
    public void initialize()
            throws Exception
    {
        if (propLocation == null)
        {
            throw new Exception("The property ojb.properties.location was not" + " found in the properties file");
        }

        if (repositoryLocation == null)
        {
            throw new Exception("The property ojb.repository.location was not" + " found in the properties file");
        }

        System.setProperty("OJB.properties", propLocation);
        pBroker = PersistenceBrokerFactory.createPersistenceBroker(repositoryLocation);
    }

    /**
     * Retrieves the initialized persistence broker
     *
     * @return the initialized Persistence Broker
     */
    public PersistenceBroker getPersistenceBroker()
    {
        return pBroker;
    }
}
