import Authenticator from './authenticator.cjs';
export default class PlainTextSaslAuthenticator extends Authenticator {
    /**
     * Creates a new instance of PlainTextSaslAuthenticator.
     * @param {string} username Username to log into the server.
     * @param {string} password Password for the user.
     * @param {string} [authzid] Optional id
     * @constructor
     */
    constructor(username: string, password: string, authzid?: string);
    /**
     * Evaluates the challenge from the server and returns appropriate response.
     * @param {String} challenge Challenge string presented by the server.
     * @return {Object} A Promise that resolves to a valid sasl response object.
     */
    evaluateChallenge(challenge: string): any;
}
