/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class RangeLocalStep<S>
extends ScalarMapStep<S, S>
implements RangeLocalStepContract<S> {
    private long low;
    private long high;

    public RangeLocalStep(Traversal.Admin traversal, long low, long high) {
        super(traversal);
        if (low != -1L && high != -1L && low > high) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + "]");
        }
        this.low = low;
        this.high = high;
    }

    @Override
    public Long getLowRange() {
        return this.low;
    }

    @Override
    public Long getHighRange() {
        return this.high;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        return (S)RangeLocalStep.applyRange(start, this.low, this.high);
    }

    static <S> S applyRange(S start, long low, long high) {
        if (start instanceof Map) {
            return (S)RangeLocalStep.applyRangeMap((Map)start, low, high);
        }
        if (start instanceof Iterable) {
            return (S)RangeLocalStep.applyRangeIterable((Iterable)start, low, high);
        }
        if (start != null && start.getClass().isArray()) {
            return (S)RangeLocalStep.applyRangeIterable(IteratorUtils.asList(start), low, high);
        }
        return start;
    }

    private static Map applyRangeMap(Map map, long low, long high) {
        long capacity = (high != -1L ? high : (long)map.size()) - low;
        LinkedHashMap result = new LinkedHashMap((int)Math.min(capacity, (long)map.size()));
        long c = 0L;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            if (c >= low) {
                if (c >= high && high != -1L) break;
                result.put(entry.getKey(), entry.getValue());
            }
            ++c;
        }
        return result;
    }

    private static Collection applyRangeIterable(Iterable<Object> iterable, long low, long high) {
        AbstractCollection resultCollection = iterable instanceof Set ? new LinkedHashSet() : new LinkedList();
        long c = 0L;
        for (Object item : iterable) {
            if (c >= low) {
                if (c >= high && high != -1L) break;
                resultCollection.add(item);
            }
            ++c;
        }
        return resultCollection;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.low, this.high);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.low) ^ Long.hashCode(this.high);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }
}

