/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;

public class TrustManagerParameters {
    private final X509Certificate[] chain;
    private final String authType;
    private final Socket socket;
    private final SSLEngine sslEngine;

    public TrustManagerParameters(X509Certificate[] chain, String authType, Socket socket, SSLEngine sslEngine) {
        this.chain = chain;
        this.authType = authType;
        this.socket = socket;
        this.sslEngine = sslEngine;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Optional<Socket> getSocket() {
        return Optional.ofNullable(this.socket);
    }

    public Optional<SSLEngine> getSslEngine() {
        return Optional.ofNullable(this.sslEngine);
    }

    public Optional<String> getHostname() {
        return TrustManagerParameters.findFirst(this.getHostnameFromSslEngine(), this.getHostnameFromSocket());
    }

    private Supplier<Optional<String>> getHostnameFromSslEngine() {
        return () -> this.getSslEngine().map(SSLEngine::getPeerHost);
    }

    private Supplier<Optional<String>> getHostnameFromSocket() {
        return () -> this.getSocket().map(socket -> socket.getInetAddress().getHostName());
    }

    public Optional<Integer> getPort() {
        return TrustManagerParameters.findFirst(this.getPortFromSslEngine(), this.getPortFromSocket());
    }

    private Supplier<Optional<Integer>> getPortFromSslEngine() {
        return () -> this.getSslEngine().map(SSLEngine::getPeerPort);
    }

    private Supplier<Optional<Integer>> getPortFromSocket() {
        return () -> this.getSocket().map(Socket::getPort);
    }

    @SafeVarargs
    private static <T> Optional<T> findFirst(Supplier<Optional<T>> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

