/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.PropertiesHolder;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.AbstractWarningVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;

public class ReservedKeysVerificationStrategy
extends AbstractWarningVerificationStrategy {
    public static final String KEYS = "keys";
    private static final Set<String> DEFAULT_RESERVED_KEYS = new LinkedHashSet<String>(Arrays.asList("id", "label"));
    private final Set<String> reservedKeys;

    private ReservedKeysVerificationStrategy(Builder builder) {
        super(builder);
        this.reservedKeys = builder.reservedKeys;
    }

    @Override
    void verify(Traversal.Admin<?, ?> traversal) throws VerificationException {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof PropertiesHolder)) continue;
            PropertiesHolder propertySettingStep = (PropertiesHolder)((Object)step);
            Map<Object, List<Object>> properties = propertySettingStep.getProperties();
            for (String key : this.reservedKeys) {
                if (!properties.containsKey(key)) continue;
                String msg = String.format("The provided traversal contains a %s that is setting a property key to a reserved word: %s", propertySettingStep.getClass().getSimpleName(), key);
                throw new VerificationException(msg, traversal);
            }
        }
    }

    public Set<String> getReservedKeys() {
        return this.reservedKeys;
    }

    public static ReservedKeysVerificationStrategy create(Configuration configuration) {
        Object listOrSet = configuration.getProperty(KEYS);
        Set<String> keys = null == listOrSet ? new LinkedHashSet<String>(DEFAULT_RESERVED_KEYS) : (listOrSet instanceof Set ? (Set)listOrSet : new LinkedHashSet((List)listOrSet));
        return ((Builder)((Builder)ReservedKeysVerificationStrategy.build().reservedKeys(keys).throwException(configuration.getBoolean("throwException", false))).logWarning(configuration.getBoolean("logWarning", false))).create();
    }

    @Override
    public Configuration getConfiguration() {
        Configuration conf = super.getConfiguration();
        conf.setProperty(KEYS, this.reservedKeys);
        return conf;
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractWarningVerificationStrategy.Builder<ReservedKeysVerificationStrategy, Builder> {
        private Set<String> reservedKeys = DEFAULT_RESERVED_KEYS;

        private Builder() {
        }

        public Builder reservedKeys(Set<String> keys) {
            this.reservedKeys = new LinkedHashSet<String>(keys);
            return this;
        }

        @Override
        public ReservedKeysVerificationStrategy create() {
            return new ReservedKeysVerificationStrategy(this);
        }
    }
}

