/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.net.URL;
import java.util.Map;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.services.SaxTemplateParser;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.Symbol;

public class TemplateParserImpl
implements TemplateParser {
    private final Map<String, URL> configuration;
    private final boolean defaultCompressWhitespace;
    private final OperationTracker tracker;

    public TemplateParserImpl(Map<String, URL> configuration, @Symbol(value="tapestry.compress-whitespace") boolean defaultCompressWhitespace, OperationTracker tracker) {
        this.configuration = configuration;
        this.defaultCompressWhitespace = defaultCompressWhitespace;
        this.tracker = tracker;
    }

    @Override
    public ComponentTemplate parseTemplate(final Resource templateResource) {
        if (!templateResource.exists()) {
            throw new RuntimeException(String.format("Template resource %s does not exist.", templateResource));
        }
        return (ComponentTemplate)this.tracker.invoke("Parsing component template " + templateResource, (Invokable)new Invokable<ComponentTemplate>(){

            public ComponentTemplate invoke() {
                return new SaxTemplateParser(templateResource, TemplateParserImpl.this.configuration).parse(TemplateParserImpl.this.defaultCompressWhitespace);
            }
        });
    }

    @Override
    public Map<String, URL> getDTDURLMappings() {
        return this.configuration;
    }
}

