/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.internal;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.MarkupWriterListener;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.services.HiddenFieldLocationRules;

public class HiddenFieldPositioner {
    private static final String ELEMENT = "input";
    private final MarkupWriter writer;
    private final HiddenFieldLocationRules rules;
    private final OneShotLock lock = new OneShotLock();
    private Element hiddenFieldElement;
    private final MarkupWriterListener listener = new MarkupWriterListener(){

        @Override
        public void elementDidStart(Element element) {
            if (HiddenFieldPositioner.this.rules.placeHiddenFieldInside(element)) {
                HiddenFieldPositioner.this.hiddenFieldElement = element.element(HiddenFieldPositioner.ELEMENT, new String[0]);
                HiddenFieldPositioner.this.writer.removeListener(this);
            }
        }

        @Override
        public void elementDidEnd(Element element) {
            if (HiddenFieldPositioner.this.rules.placeHiddenFieldAfter(element)) {
                HiddenFieldPositioner.this.hiddenFieldElement = element.getContainer().element(HiddenFieldPositioner.ELEMENT, new String[0]);
                HiddenFieldPositioner.this.writer.removeListener(this);
            }
        }
    };

    public HiddenFieldPositioner(MarkupWriter writer, HiddenFieldLocationRules rules) {
        this.writer = writer;
        this.rules = rules;
        this.writer.addListener(this.listener);
    }

    public Element getElement() {
        this.lock.lock();
        this.writer.removeListener(this.listener);
        if (this.hiddenFieldElement == null) {
            throw new IllegalStateException("The rendered content did not include any elements that allow for the positioning of the hidden form field's element.");
        }
        return this.hiddenFieldElement;
    }

    public void discard() {
        this.lock.lock();
        if (this.hiddenFieldElement != null) {
            this.hiddenFieldElement.remove();
        }
        this.writer.removeListener(this.listener);
    }
}

