/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.source.doctree.DocTree;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Taglet;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.javadoc.ClassDescription;
import org.apache.tapestry5.javadoc.ClassDescriptionSource;
import org.apache.tapestry5.javadoc.ParameterDescription;
import org.apache.tapestry5.javadoc.XDocStreamer;

public class TapestryDocTaglet
implements Taglet,
ClassDescriptionSource {
    private DocletEnvironment env;
    private Doclet doclet;
    private final Map<String, ClassDescription> classDescriptions = CollectionFactory.newMap();
    private final Set<Taglet.Location> allowedLocations = CollectionFactory.newSet((Object[])new Taglet.Location[]{Taglet.Location.TYPE});
    private Element firstSeen;
    private static final String NAME = "tapestrydoc";

    public static void register(Map paramMap) {
        paramMap.put(NAME, new TapestryDocTaglet());
    }

    @Override
    public void init(DocletEnvironment env, Doclet doclet) {
        this.env = env;
        this.doclet = doclet;
    }

    @Override
    public Set<Taglet.Location> getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString(List<? extends DocTree> tags, Element element) {
        if (tags.size() == 0) {
            return null;
        }
        DocTree tag = tags.get(0);
        try {
            StringWriter writer = new StringWriter(5000);
            TypeElement classDoc = (TypeElement)element;
            if (this.firstSeen == null) {
                this.firstSeen = classDoc;
            }
            ClassDescription cd = this.getDescription(classDoc.getQualifiedName().toString());
            this.writeClassDescription(cd, writer);
            this.streamXdoc(classDoc, writer);
            return writer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
    }

    @Override
    public ClassDescription getDescription(String className) {
        ClassDescription result = this.classDescriptions.get(className);
        if (result == null) {
            TypeElement cd = this.env.getElementUtils().getTypeElement(className);
            result = cd == null ? new ClassDescription(this.env) : new ClassDescription(cd, this, this.env);
            this.classDescriptions.put(className, result);
        }
        return result;
    }

    private void writeElement(Writer writer, String elementSpec, String text) throws IOException {
        String elementName = elementSpec;
        int idxOfSpace = elementSpec.indexOf(32);
        if (idxOfSpace != -1) {
            elementName = elementSpec.substring(0, idxOfSpace);
        }
        writer.write(String.format("<%s>%s</%s>", elementSpec, InternalUtils.isBlank((String)text) ? "&nbsp;" : text, elementName));
    }

    private void writeClassDescription(ClassDescription cd, Writer writer) throws IOException {
        this.writeParameters(cd, writer);
        this.writeEvents(cd, writer);
    }

    private void writeParameters(ClassDescription cd, Writer writer) throws IOException {
        if (cd.parameters.isEmpty()) {
            return;
        }
        writer.write("</dl><table class='parameters'><caption><span>Component Parameters</span><span class='tabEnd'>&nbsp;</span></caption><tr class='columnHeaders'><th class='colFirst'>Name</th><th>Type</th><th>Flags</th><th>Default</th><th class='colLast'>Default Prefix</th></tr><tbody>");
        int toggle = 0;
        for (String name : InternalUtils.sortedKeys(cd.parameters)) {
            ParameterDescription pd = cd.parameters.get(name);
            this.writerParameter(pd, this.alternateCssClass(toggle++), writer);
        }
        writer.write("</tbody></table></dd>");
    }

    private void writerParameter(ParameterDescription pd, String rowClass, Writer writer) throws IOException {
        String description = pd.extractDescription();
        writer.write("<tr class='values " + rowClass + "'>");
        writer.write("<td" + (StringUtils.isEmpty((String)description) ? "" : " rowspan='2'") + " class='colFirst'>");
        writer.write(pd.name);
        writer.write("</td>");
        this.writeElement(writer, "td", this.addWordBreaks(this.shortenClassName(pd.type)));
        List flags = CollectionFactory.newList();
        if (pd.required) {
            flags.add("Required");
        }
        if (!pd.cache) {
            flags.add("Not Cached");
        }
        if (!pd.allowNull) {
            flags.add("Not Null");
        }
        if (InternalUtils.isNonBlank((String)pd.since)) {
            flags.add("Since " + pd.since);
        }
        this.writeElement(writer, "td", InternalUtils.join((List)flags));
        this.writeElement(writer, "td", this.addWordBreaks(pd.defaultValue));
        this.writeElement(writer, "td class='colLast'", pd.defaultPrefix);
        writer.write("</tr>");
        if (StringUtils.isNotEmpty((String)description)) {
            writer.write("<tr class='" + rowClass + "'>");
            writer.write("<td colspan='4' class='description colLast'>");
            writer.write(description);
            writer.write("</td>");
            writer.write("</tr>");
        }
    }

    private String alternateCssClass(int num) {
        return num % 2 == 0 ? "altColor" : "rowColor";
    }

    private void writeEvents(ClassDescription cd, Writer writer) throws IOException {
        if (cd.events.isEmpty()) {
            return;
        }
        writer.write("<p><table class='parameters'><caption><span>Component Events</span><span class='tabEnd'>&nbsp;</span></caption><tr class='columnHeaders'><th class='colFirst'>Name</th><th class='colLast'>Description</th></tr><tbody>");
        int toggle = 0;
        for (String name : InternalUtils.sortedKeys(cd.events)) {
            writer.write("<tr class='" + this.alternateCssClass(toggle++) + "'>");
            this.writeElement(writer, "td class='colFirst'", name);
            String value = cd.events.get(name);
            this.writeElement(writer, "td class='colLast'", value);
            writer.write("</tr>");
        }
        writer.write("</table></p>");
    }

    private String addWordBreaks(String words) {
        return words.replace(".", ".<wbr/>").replace(":", ":<wbr/>");
    }

    private String shortenClassName(String name) {
        return name.replace("java.lang.", "");
    }

    private void streamXdoc(TypeElement classDoc, Writer writer) throws Exception {
        File sourceFile;
        JavaFileObject sourceFileObject = this.env.getJavaFileManager().getJavaFileForInput(StandardLocation.SOURCE_PATH, classDoc.getQualifiedName().toString(), JavaFileObject.Kind.SOURCE);
        if (sourceFileObject == null) {
            String path = "./tapestry-core/src/main/java/" + classDoc.getQualifiedName().toString().replace('.', '/') + ".java";
            System.err.println("[WARNING] Source file object not found for " + classDoc.getQualifiedName().toString() + ", so we'll guess it's in " + path);
            sourceFile = new File(path);
        } else {
            sourceFile = new File(sourceFileObject.toUri());
        }
        String sourceName = sourceFile.getName();
        String xdocName = sourceName.replaceAll("\\.java$", ".xdoc");
        File xdocFile = new File(sourceFile.getParentFile(), xdocName);
        if (xdocFile.exists()) {
            try {
                new XDocStreamer(xdocFile, writer).writeContent();
            }
            catch (Exception ex) {
                System.err.println("Error streaming XDOC content for " + classDoc);
                throw ex;
            }
        }
    }
}

