/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.services.MethodSignature;

public class MethodIterator {
    private boolean toString;
    private int index = 0;
    private final int count;
    private final List<MethodSignature> signatures;
    private static final Comparator<MethodSignature> COMPARATOR = new Comparator<MethodSignature>(){

        @Override
        public int compare(MethodSignature o1, MethodSignature o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public MethodIterator(Class subjectClass) {
        Method[] methods = subjectClass.getMethods();
        Map map = CollectionFactory.newMap();
        for (int i = 0; i < methods.length; ++i) {
            this.processMethod(methods[i], map);
        }
        this.signatures = CollectionFactory.newList(map.values());
        this.count = this.signatures.size();
        Collections.sort(this.signatures, COMPARATOR);
    }

    public static boolean isToString(Method method) {
        if (!method.getName().equals("toString")) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return method.getReturnType().equals(String.class);
    }

    private void processMethod(Method m, Map<String, MethodSignature> map) {
        this.toString |= MethodIterator.isToString(m);
        MethodSignature sig = new MethodSignature(m);
        String uid = sig.getUniqueId();
        MethodSignature existing = map.get(uid);
        if (existing == null || sig.isOverridingSignatureOf(existing)) {
            map.put(uid, sig);
        }
    }

    public boolean hasNext() {
        return this.index < this.count;
    }

    public MethodSignature next() {
        if (this.index >= this.count) {
            throw new NoSuchElementException();
        }
        return this.signatures.get(this.index++);
    }

    public boolean getToString() {
        return this.toString;
    }
}

