/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest.dispatch;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.rest.RESTUtils;
import org.apache.synapse.rest.Resource;
import org.apache.synapse.rest.dispatch.DispatcherHelper;
import org.apache.synapse.rest.dispatch.RESTDispatcher;
import org.apache.synapse.rest.dispatch.URLMappingHelper;

public class URLMappingBasedDispatcher
implements RESTDispatcher {
    private static final Log log = LogFactory.getLog(URLMappingBasedDispatcher.class);

    @Override
    public Resource findResource(MessageContext synCtx, Collection<Resource> resources) {
        int i;
        ArrayList<URLMappingHelper> mappings = new ArrayList<URLMappingHelper>();
        ArrayList<Resource> filteredResources = new ArrayList<Resource>();
        for (Resource r : resources) {
            DispatcherHelper helper = r.getDispatcherHelper();
            if (!(helper instanceof URLMappingHelper)) continue;
            mappings.add((URLMappingHelper)helper);
            filteredResources.add(r);
        }
        int count = filteredResources.size();
        if (count == 0) {
            return null;
        }
        String url = RESTUtils.getSubRequestPath(synCtx);
        for (int i2 = 0; i2 < count; ++i2) {
            if (!((URLMappingHelper)mappings.get(i2)).isExactMatch(url)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found exact URL match for: " + url));
            }
            return (Resource)filteredResources.get(i2);
        }
        int maxLength = 0;
        Resource matchedResource = null;
        for (i = 0; i < count; ++i) {
            int length = ((URLMappingHelper)mappings.get(i)).getPrefixMatchingLength(url);
            if (length <= maxLength) continue;
            maxLength = length;
            matchedResource = (Resource)filteredResources.get(i);
        }
        if (matchedResource != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found path match for: " + url + " with matching length: " + maxLength));
            }
            return matchedResource;
        }
        for (i = 0; i < count; ++i) {
            if (!((URLMappingHelper)mappings.get(i)).isExtensionMatch(url)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found extension match for: " + url));
            }
            return (Resource)filteredResources.get(i);
        }
        return null;
    }
}

