/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault;

import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.synapse.securevault.BaseCipher;
import org.apache.synapse.securevault.CipherOperationMode;
import org.apache.synapse.securevault.definition.CipherInformation;
import org.apache.synapse.securevault.definition.KeyStoreInformation;
import org.apache.synapse.securevault.keystore.KeyStoreWrapper;

public class SymmetricCipher
extends BaseCipher {
    private SecretKeySpec defaultKeySpec;

    public SymmetricCipher(CipherInformation cipherInformation, KeyStoreInformation keystoreInformation) {
        super(cipherInformation, keystoreInformation);
    }

    public SymmetricCipher(CipherInformation cipherInformation, KeyStoreWrapper keyStoreWrapper) {
        super(cipherInformation, keyStoreWrapper);
    }

    public SymmetricCipher(CipherInformation cipherInformation, Key key) {
        super(cipherInformation, key);
    }

    @Override
    public Key getKey(CipherOperationMode operationMode) {
        SecretKey secretKey = this.keyStoreWrapper.getSecretKey();
        if (secretKey == null) {
            if (this.defaultKeySpec == null) {
                this.defaultKeySpec = this.createDefaultKey();
            }
            return this.defaultKeySpec;
        }
        return secretKey;
    }

    private SecretKeySpec createDefaultKey() {
        byte[] keyBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 0, 0, 0, 0, 1};
        this.defaultKeySpec = new SecretKeySpec(keyBytes, "AES");
        return this.defaultKeySpec;
    }
}

