/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.Validator;
import org.opensaml.xml.validation.ValidatorSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConfigurator {
    private final Logger log = LoggerFactory.getLogger(XMLConfigurator.class);
    private boolean retainXMLConfiguration;
    private BasicParserPool parserPool;
    private Schema configurationSchema;

    public XMLConfigurator() throws ConfigurationException {
        this(false);
    }

    public XMLConfigurator(boolean retainXML) throws ConfigurationException {
        this.retainXMLConfiguration = retainXML;
        this.parserPool = new BasicParserPool();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(XMLConfigurator.class.getResourceAsStream("/schema/xmltooling-config.xsd"));
        try {
            this.configurationSchema = factory.newSchema(schemaSource);
            this.parserPool.setIgnoreComments(true);
            this.parserPool.setIgnoreElementContentWhitespace(true);
            this.parserPool.setSchema(this.configurationSchema);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Unable to read XMLTooling configuration schema", e);
        }
    }

    public void load(File configurationFile) throws ConfigurationException {
        if (configurationFile == null || !configurationFile.canRead()) {
            this.log.error("Unable to read configuration file {}", (Object)configurationFile);
        }
        try {
            if (configurationFile.isDirectory()) {
                File[] configurations = configurationFile.listFiles();
                for (int i = 0; i < configurations.length; ++i) {
                    this.log.debug("Parsing configuration file {}", (Object)configurations[i].getAbsolutePath());
                    this.load(new FileInputStream(configurations[i]));
                }
            } else {
                this.log.debug("Parsing configuration file {}", (Object)configurationFile.getAbsolutePath());
                this.load(new FileInputStream(configurationFile));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void load(InputStream configurationStream) throws ConfigurationException {
        try {
            Document configuration = this.parserPool.parse(configurationStream);
            this.load(configuration);
        }
        catch (XMLParserException e) {
            this.log.error("Invalid configuration file", (Throwable)e);
            throw new ConfigurationException("Unable to create DocumentBuilder", e);
        }
    }

    public void load(Document configuration) throws ConfigurationException {
        this.log.debug("Loading configuration from XML Document");
        this.log.trace("{}", (Object)XMLHelper.nodeToString(configuration.getDocumentElement()));
        this.log.debug("Schema validating configuration Document");
        this.validateConfiguration(configuration);
        this.log.debug("Configuration document validated");
        this.load(configuration.getDocumentElement());
    }

    protected void load(Element configurationRoot) throws ConfigurationException {
        NodeList idAttributesNodes;
        NodeList validatorSuitesNodes;
        NodeList objectProviders = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ObjectProviders");
        if (objectProviders.getLength() > 0) {
            this.log.debug("Preparing to load ObjectProviders");
            this.initializeObjectProviders((Element)objectProviders.item(0));
            this.log.debug("ObjectProviders load complete");
        }
        if ((validatorSuitesNodes = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ValidatorSuites")).getLength() > 0) {
            this.log.debug("Preparing to load ValidatorSuites");
            this.initializeValidatorSuites((Element)validatorSuitesNodes.item(0));
            this.log.debug("ValidatorSuites load complete");
        }
        if ((idAttributesNodes = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "IDAttributes")).getLength() > 0) {
            this.log.debug("Preparing to load IDAttributes");
            this.initializeIDAttributes((Element)idAttributesNodes.item(0));
            this.log.debug("IDAttributes load complete");
        }
    }

    protected void initializeObjectProviders(Element objectProviders) throws ConfigurationException {
        NodeList providerList = objectProviders.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ObjectProvider");
        for (int i = 0; i < providerList.getLength(); ++i) {
            Element objectProvider = (Element)providerList.item(i);
            Attr qNameAttrib = objectProvider.getAttributeNodeNS(null, "qualifiedName");
            QName objectProviderName = XMLHelper.getAttributeValueAsQName(qNameAttrib);
            this.log.debug("Initializing object provider {}", (Object)objectProviderName);
            try {
                Element configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "BuilderClass").item(0);
                XMLObjectBuilder builder = (XMLObjectBuilder)this.createClassInstance(configuration);
                configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "MarshallingClass").item(0);
                Marshaller marshaller = (Marshaller)this.createClassInstance(configuration);
                configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "UnmarshallingClass").item(0);
                Unmarshaller unmarshaller = (Unmarshaller)this.createClassInstance(configuration);
                if (this.retainXMLConfiguration) {
                    Configuration.registerObjectProvider(objectProviderName, builder, marshaller, unmarshaller, objectProvider);
                } else {
                    Configuration.registerObjectProvider(objectProviderName, builder, marshaller, unmarshaller);
                }
                this.log.debug("{} intialized and configuration cached", (Object)objectProviderName);
                continue;
            }
            catch (ConfigurationException e) {
                this.log.error("Error initializing object provier " + objectProvider, (Throwable)e);
                Configuration.deregisterObjectProvider(objectProviderName);
                throw e;
            }
        }
    }

    protected void initializeValidatorSuites(Element validatorSuitesElement) throws ConfigurationException {
        NodeList validatorSuiteList = validatorSuitesElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ValidatorSuite");
        for (int i = 0; i < validatorSuiteList.getLength(); ++i) {
            Element validatorSuiteElement = (Element)validatorSuiteList.item(i);
            String validatorSuiteId = validatorSuiteElement.getAttributeNS(null, "id");
            ValidatorSuite validatorSuite = new ValidatorSuite(validatorSuiteId);
            this.log.debug("Initializing ValidatorSuite {}", (Object)validatorSuiteId);
            this.log.trace(XMLHelper.nodeToString(validatorSuiteElement));
            NodeList validatorList = validatorSuiteElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "Validator");
            for (int j = 0; j < validatorList.getLength(); ++j) {
                Element validatorElement = (Element)validatorList.item(j);
                QName validatorQName = XMLHelper.getAttributeValueAsQName(validatorElement.getAttributeNodeNS(null, "qualifiedName"));
                Validator validator = (Validator)this.createClassInstance(validatorElement);
                validatorSuite.registerValidator(validatorQName, validator);
            }
            this.log.debug("ValidtorSuite {} has been initialized", (Object)validatorSuiteId);
            if (this.retainXMLConfiguration) {
                Configuration.registerValidatorSuite(validatorSuiteId, validatorSuite, validatorSuiteElement);
                continue;
            }
            Configuration.registerValidatorSuite(validatorSuiteId, validatorSuite);
        }
    }

    protected void initializeIDAttributes(Element idAttributesElement) throws ConfigurationException {
        NodeList idAttributeList = idAttributesElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "IDAttribute");
        for (int i = 0; i < idAttributeList.getLength(); ++i) {
            Element idAttributeElement = (Element)idAttributeList.item(i);
            QName attributeQName = XMLHelper.getElementContentAsQName(idAttributeElement);
            if (attributeQName == null) {
                this.log.debug("IDAttribute element was empty, no registration performed");
                continue;
            }
            Configuration.registerIDAttribute(attributeQName);
            this.log.debug("IDAttribute {} has been registered", (Object)attributeQName);
        }
    }

    protected Object createClassInstance(Element configuration) throws ConfigurationException {
        String className = configuration.getAttributeNS(null, "className");
        if ((className = DatatypeHelper.safeTrimOrNullString(className)) == null) {
            return null;
        }
        try {
            this.log.trace("Creating instance of {}", (Object)className);
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Can not create instance of " + className, (Throwable)e);
            throw new ConfigurationException("Can not create instance of " + className, e);
        }
    }

    protected void validateConfiguration(Document configuration) throws ConfigurationException {
        try {
            javax.xml.validation.Validator schemaValidator = this.configurationSchema.newValidator();
            schemaValidator.validate(new DOMSource(configuration));
        }
        catch (IOException e) {
            String errorMsg = "Unable to read configuration file DOM";
            this.log.error(errorMsg, (Throwable)e);
            throw new ConfigurationException(errorMsg, e);
        }
        catch (SAXException e) {
            String errorMsg = "Configuration file does not validate against schema";
            this.log.error(errorMsg, (Throwable)e);
            throw new ConfigurationException(errorMsg, e);
        }
    }
}

