/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQExpression;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQMetaData;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQSequenceType;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQExpression;
import net.sf.saxon.xqj.SaxonXQItemType;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;

public class SaxonXQConnection
extends SaxonXQDataFactory
implements XQConnection {
    private Configuration config;
    private XQCommonHandler commonHandler;
    private boolean closed;
    private int holdability = 1;
    private int scrollability = 1;

    SaxonXQConnection(SaxonXQDataSource saxonXQDataSource) {
        this.config = saxonXQDataSource.getConfiguration();
        this.commonHandler = saxonXQDataSource.getCommonHandler();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XQCommonHandler getCommonHandler() {
        return this.commonHandler;
    }

    public void clearWarnings() throws XQException {
        this.checkNotClosed();
    }

    public void close() {
        this.closed = true;
    }

    public void commit() throws XQException {
        this.checkNotClosed();
    }

    public XQExpression createExpression() throws XQException {
        this.checkNotClosed();
        return new SaxonXQExpression(this);
    }

    public int getHoldability() throws XQException {
        this.checkNotClosed();
        return this.holdability;
    }

    public XQMetaData getMetaData() throws XQException {
        this.checkNotClosed();
        throw new UnsupportedOperationException("Metadata is not yet implemented");
    }

    public String getMetaDataProperty(String string) throws XQException {
        this.checkNotClosed();
        throw new UnsupportedOperationException("Metadata is not yet implemented");
    }

    public int getQueryLanguageTypeAndVersion() throws XQException {
        this.checkNotClosed();
        return 1;
    }

    public int getScrollability() throws XQException {
        this.checkNotClosed();
        return this.scrollability;
    }

    public String[] getSupportedMetaDataPropertyNames() throws XQException {
        this.checkNotClosed();
        throw new UnsupportedOperationException("Metadata is not yet implemented");
    }

    public int getUpdatability() throws XQException {
        this.checkNotClosed();
        return 1;
    }

    public XQWarning getWarnings() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public XQPreparedExpression prepareExpression(InputStream inputStream) throws XQException {
        return this.prepareExpression(inputStream, null);
    }

    public XQPreparedExpression prepareExpression(InputStream inputStream, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            if (xQItemType != null) {
                staticQueryContext.setRequiredContextItemType(((SaxonXQItemType)xQItemType).getSaxonItemType());
            }
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(inputStream, null);
            DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, xQueryExpression, dynamicQueryContext);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
        catch (IOException iOException) {
            throw new XQException(iOException.getMessage(), (Throwable)iOException, null, null);
        }
    }

    public XQPreparedExpression prepareExpression(Reader reader) throws XQException {
        return this.prepareExpression(reader, null);
    }

    public XQPreparedExpression prepareExpression(Reader reader, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            if (xQItemType != null) {
                staticQueryContext.setRequiredContextItemType(((SaxonXQItemType)xQItemType).getSaxonItemType());
            }
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(reader);
            DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, xQueryExpression, dynamicQueryContext);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
        catch (IOException iOException) {
            throw new XQException(iOException.getMessage(), (Throwable)iOException, null, null);
        }
    }

    public XQPreparedExpression prepareExpression(String string) throws XQException {
        return this.prepareExpression(string, null);
    }

    public XQPreparedExpression prepareExpression(String string, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            if (xQItemType != null) {
                staticQueryContext.setRequiredContextItemType(((SaxonXQItemType)xQItemType).getSaxonItemType());
            }
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(string);
            DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, xQueryExpression, dynamicQueryContext);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void rollback() throws XQException {
        this.checkNotClosed();
    }

    public void setCommonHandler(XQCommonHandler xQCommonHandler) {
        this.commonHandler = xQCommonHandler;
    }

    public void setHoldability(int n) throws XQException {
        this.checkNotClosed();
        switch (n) {
            case 1: 
            case 2: {
                this.holdability = n;
            }
        }
        throw new XQException("Invalid holdability value - " + n);
    }

    public void setQueryLanguageTypeAndVersion(int n) throws XQException {
        this.checkNotClosed();
        if (n != 1) {
            throw new XQException("XQueryX is not supported");
        }
    }

    public void setScrollability(int n) throws XQException {
        this.checkNotClosed();
        switch (n) {
            case 1: 
            case 2: {
                this.scrollability = n;
            }
        }
        throw new XQException("Invalid scrollability value - " + n);
    }

    public void setUpdatability(int n) throws XQException {
        this.checkNotClosed();
        if (n != 1) {
            throw new XQException("Query must be read-only");
        }
    }

    public String getBaseURI() throws XQException {
        return null;
    }

    public int getBoundarySpacePolicy() throws XQException {
        return 2;
    }

    public int getConstructionMode() throws XQException {
        return 2;
    }

    public int getCopyNamespacesModeInherit() throws XQException {
        return 1;
    }

    public int getCopyNamespacesModePreserve() throws XQException {
        return 1;
    }

    public String getDefaultCollation() throws XQException {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public String getDefaultElementTypeNamespace() throws XQException {
        return "";
    }

    public String getDefaultFunctionNamespace() throws XQException {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public int getDefaultOrderForEmptySequences() throws XQException {
        return 2;
    }

    public String[] getInScopeNamespacePrefixes() throws XQException {
        String[] stringArray = new String[]{"xs", "xdt", "local", "xsi", "xml", "fn"};
        return stringArray;
    }

    public String getNamespaceURI(String string) throws XQException {
        if (string.equals("xs")) {
            return "http://www.w3.org/2001/XMLSchema";
        }
        if (string.equals("xsi")) {
            return "http://www.w3.org/2001/XMLSchema-instance";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("fn")) {
            return "http://www.w3.org/2005/xpath-functions";
        }
        throw new XQException("No namespace is bound to prefix " + string);
    }

    public int getOrderingMode() throws XQException {
        return 1;
    }

    public QName[] getStaticInScopeVariableNames() throws XQException {
        return new QName[0];
    }

    public XQSequenceType getStaticInScopeVariableType(QName qName) throws XQException {
        return null;
    }

    private void checkNotClosed() throws XQException {
        if (this.closed) {
            throw new XQException("Connection has been closed");
        }
    }
}

