/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.parse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.opensaml.xml.parse.LoggingErrorHandler;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicParserPool
implements ParserPool {
    private final Logger log = LoggerFactory.getLogger(BasicParserPool.class);
    private long poolVersion;
    private boolean dirtyBuilderConfiguration;
    private DocumentBuilderFactory builderFactory;
    private Stack<SoftReference<DocumentBuilder>> builderPool = new Stack();
    private int maxPoolSize = 5;
    private Map<String, Object> builderAttributes = new LazyMap<String, Object>();
    private boolean coalescing = true;
    private boolean expandEntityReferences = true;
    private Map<String, Boolean> builderFeatures = new LazyMap<String, Boolean>();
    private boolean ignoreComments = true;
    private boolean ignoreElementContentWhitespace = true;
    private boolean namespaceAware = true;
    private Schema schema = null;
    private boolean dtdValidating = false;
    private boolean xincludeAware = false;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new LoggingErrorHandler(this.log);

    public BasicParserPool() {
        try {
            this.dirtyBuilderConfiguration = true;
            this.initializePool();
        }
        catch (XMLParserException xMLParserException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentBuilder getBuilder() throws XMLParserException {
        DocumentBuilder builder = null;
        long version = 0L;
        if (this.dirtyBuilderConfiguration) {
            this.initializePool();
        }
        BasicParserPool basicParserPool = this;
        synchronized (basicParserPool) {
            version = this.getPoolVersion();
            if (!this.builderPool.isEmpty()) {
                builder = this.builderPool.pop().get();
            }
            if (builder == null) {
                builder = this.createBuilder();
            }
        }
        if (builder != null) {
            return new DocumentBuilderProxy(builder, this, version);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuilder(DocumentBuilder builder) {
        if (!(builder instanceof DocumentBuilderProxy)) {
            return;
        }
        DocumentBuilderProxy proxiedBuilder = (DocumentBuilderProxy)builder;
        if (proxiedBuilder.getOwningPool() != this) {
            return;
        }
        BasicParserPool basicParserPool = this;
        synchronized (basicParserPool) {
            if (proxiedBuilder.isReturned()) {
                return;
            }
            if (proxiedBuilder.getPoolVersion() != this.poolVersion) {
                return;
            }
            DocumentBuilder unwrappedBuilder = proxiedBuilder.getProxiedBuilder();
            unwrappedBuilder.reset();
            SoftReference<DocumentBuilder> builderReference = new SoftReference<DocumentBuilder>(unwrappedBuilder);
            if (this.builderPool.size() < this.maxPoolSize) {
                proxiedBuilder.setReturned(true);
                this.builderPool.push(builderReference);
            }
        }
    }

    @Override
    public Document newDocument() throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        Document document = builder.newDocument();
        this.returnBuilder(builder);
        return document;
    }

    @Override
    public Document parse(InputStream input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(input);
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    @Override
    public Document parse(Reader input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(new InputSource(input));
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int newSize) {
        this.maxPoolSize = newSize;
    }

    public boolean getCreateBuildersAtPoolLimit() {
        return true;
    }

    public void setCreateBuildersAtPoolLimit(boolean createBuilders) {
    }

    public Map<String, Object> getBuilderAttributes() {
        return Collections.unmodifiableMap(this.builderAttributes);
    }

    public synchronized void setBuilderAttributes(Map<String, Object> newAttributes) {
        this.builderAttributes = newAttributes;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public synchronized void setCoalescing(boolean isCoalescing) {
        this.coalescing = isCoalescing;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public synchronized void setExpandEntityReferences(boolean expand) {
        this.expandEntityReferences = expand;
        this.dirtyBuilderConfiguration = true;
    }

    public Map<String, Boolean> getBuilderFeatures() {
        return Collections.unmodifiableMap(this.builderFeatures);
    }

    public synchronized void setBuilderFeatures(Map<String, Boolean> newFeatures) {
        this.builderFeatures = newFeatures;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean getIgnoreComments() {
        return this.ignoreComments;
    }

    public synchronized void setIgnoreComments(boolean ignore) {
        this.ignoreComments = ignore;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isIgnoreElementContentWhitespace() {
        return this.ignoreElementContentWhitespace;
    }

    public synchronized void setIgnoreElementContentWhitespace(boolean ignore) {
        this.ignoreElementContentWhitespace = ignore;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public synchronized void setNamespaceAware(boolean isNamespaceAware) {
        this.namespaceAware = isNamespaceAware;
        this.dirtyBuilderConfiguration = true;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public synchronized void setSchema(Schema newSchema) {
        this.schema = newSchema;
        if (this.schema != null) {
            this.setNamespaceAware(true);
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaSource");
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
        }
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isDTDValidating() {
        return this.dtdValidating;
    }

    public synchronized void setDTDValidating(boolean isValidating) {
        this.dtdValidating = isValidating;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isXincludeAware() {
        return this.xincludeAware;
    }

    public synchronized void setXincludeAware(boolean isXIncludeAware) {
        this.xincludeAware = isXIncludeAware;
        this.dirtyBuilderConfiguration = true;
    }

    protected long getPoolVersion() {
        return this.poolVersion;
    }

    protected int getPoolSize() {
        return this.builderPool.size();
    }

    protected synchronized void initializePool() throws XMLParserException {
        if (!this.dirtyBuilderConfiguration) {
            return;
        }
        DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
        this.setAttributes(newFactory, this.builderAttributes);
        this.setFeatures(newFactory, this.builderFeatures);
        newFactory.setCoalescing(this.coalescing);
        newFactory.setExpandEntityReferences(this.expandEntityReferences);
        newFactory.setIgnoringComments(this.ignoreComments);
        newFactory.setIgnoringElementContentWhitespace(this.ignoreElementContentWhitespace);
        newFactory.setNamespaceAware(this.namespaceAware);
        newFactory.setSchema(this.schema);
        newFactory.setValidating(this.dtdValidating);
        newFactory.setXIncludeAware(this.xincludeAware);
        ++this.poolVersion;
        this.dirtyBuilderConfiguration = false;
        this.builderFactory = newFactory;
        this.builderPool.clear();
    }

    protected void setAttributes(DocumentBuilderFactory factory, Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            try {
                this.log.debug("Setting DocumentBuilderFactory attribute '{}'", (Object)attribute.getKey());
                factory.setAttribute(attribute.getKey(), attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("DocumentBuilderFactory attribute '{}' is not supported", (Object)attribute.getKey());
            }
        }
    }

    protected void setFeatures(DocumentBuilderFactory factory, Map<String, Boolean> features) {
        if (features == null || features.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : features.entrySet()) {
            try {
                this.log.debug("Setting DocumentBuilderFactory attribute '{}'", (Object)feature.getKey());
                factory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (ParserConfigurationException e) {
                this.log.warn("DocumentBuilderFactory feature '{}' is not supported", (Object)feature.getKey());
            }
        }
    }

    protected DocumentBuilder createBuilder() throws XMLParserException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            if (this.entityResolver != null) {
                builder.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                builder.setErrorHandler(this.errorHandler);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            this.log.error("Unable to create new document builder", (Throwable)e);
            throw new XMLParserException("Unable to create new document builder", e);
        }
    }

    protected class DocumentBuilderProxy
    extends DocumentBuilder {
        private DocumentBuilder builder;
        private ParserPool owningPool;
        private long owningPoolVersion;
        private boolean returned;

        public DocumentBuilderProxy(DocumentBuilder target, BasicParserPool owner, long version) {
            this.owningPoolVersion = version;
            this.owningPool = owner;
            this.builder = target;
            this.returned = false;
        }

        public DOMImplementation getDOMImplementation() {
            this.checkValidState();
            return this.builder.getDOMImplementation();
        }

        public Schema getSchema() {
            this.checkValidState();
            return this.builder.getSchema();
        }

        public boolean isNamespaceAware() {
            this.checkValidState();
            return this.builder.isNamespaceAware();
        }

        public boolean isValidating() {
            this.checkValidState();
            return this.builder.isValidating();
        }

        public boolean isXIncludeAware() {
            this.checkValidState();
            return this.builder.isXIncludeAware();
        }

        public Document newDocument() {
            this.checkValidState();
            return this.builder.newDocument();
        }

        public Document parse(File f) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(f);
        }

        public Document parse(InputSource is) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is);
        }

        public Document parse(InputStream is) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is);
        }

        public Document parse(InputStream is, String systemId) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is, systemId);
        }

        public Document parse(String uri) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(uri);
        }

        public void reset() {
        }

        public void setEntityResolver(EntityResolver er) {
            this.checkValidState();
        }

        public void setErrorHandler(ErrorHandler eh) {
            this.checkValidState();
        }

        protected ParserPool getOwningPool() {
            return this.owningPool;
        }

        protected long getPoolVersion() {
            return this.owningPoolVersion;
        }

        protected DocumentBuilder getProxiedBuilder() {
            return this.builder;
        }

        protected boolean isReturned() {
            return this.returned;
        }

        protected void setReturned(boolean isReturned) {
            this.returned = isReturned;
        }

        protected void checkValidState() throws IllegalStateException {
            if (this.isReturned()) {
                throw new IllegalStateException("DocumentBuilderProxy has already been returned to its owning pool");
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.owningPool.returnBuilder(this);
        }
    }
}

