/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.AlgorithmSuiteValidator;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.str.EncryptedKeySTRParser;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeyProcessor
implements Processor {
    private static Log log = LogFactory.getLog(EncryptedKeyProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        return this.handleToken(elem, data, wsDocInfo, data.getAlgorithmSuite());
    }

    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo, AlgorithmSuite algorithmSuite) throws WSSecurityException {
        WSSecurityEngineResult result;
        String id;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found encrypted key element");
        }
        if (!"".equals(id = elem.getAttributeNS(null, "Id")) && (result = wsDocInfo.getResult(id)) != null && 4 == (Integer)result.get("action")) {
            return Collections.singletonList(result);
        }
        if (data.getDecCrypto() == null) {
            throw new WSSecurityException(0, "noDecCryptoFile");
        }
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        String encryptedKeyTransportMethod = X509Util.getEncAlgo(elem);
        if (encryptedKeyTransportMethod == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (data.getWssConfig().isWsiBSPCompliant()) {
            this.checkBSPCompliance(elem, encryptedKeyTransportMethod);
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(encryptedKeyTransportMethod);
        Element tmpE = WSSecurityUtil.getDirectChildElement(elem, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        Element xencCipherValue = null;
        if (tmpE != null) {
            xencCipherValue = WSSecurityUtil.getDirectChildElement(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        EncryptedKeySTRParser strParser = new EncryptedKeySTRParser();
        X509Certificate[] certs = this.getCertificatesFromEncryptedKey(elem, data, data.getDecCrypto(), wsDocInfo, strParser);
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkAsymmetricKeyLength(certs[0]);
            algorithmSuiteValidator.checkEncryptionKeyWrapAlgorithm(encryptedKeyTransportMethod);
        }
        try {
            PrivateKey privateKey = data.getDecCrypto().getPrivateKey(certs[0], data.getCallbackHandler());
            OAEPParameterSpec oaepParameterSpec = null;
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptedKeyTransportMethod)) {
                String digestAlgorithm = EncryptedKeyProcessor.getDigestAlgorithm(elem);
                String jceDigestAlgorithm = "SHA-1";
                if (digestAlgorithm != null && !"".equals(digestAlgorithm)) {
                    jceDigestAlgorithm = JCEMapper.translateURItoJCEID((String)digestAlgorithm);
                }
                oaepParameterSpec = new OAEPParameterSpec(jceDigestAlgorithm, "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
            }
            if (oaepParameterSpec == null) {
                cipher.init(2, privateKey);
            } else {
                cipher.init(2, (Key)privateKey, oaepParameterSpec);
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        List<String> dataRefURIs = this.getDataRefURIs(elem);
        byte[] encryptedEphemeralKey = null;
        byte[] decryptedBytes = null;
        try {
            encryptedEphemeralKey = EncryptedKeyProcessor.getDecodedBase64EncodedData(xencCipherValue);
            decryptedBytes = cipher.doFinal(encryptedEphemeralKey);
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        catch (Exception ex) {
            decryptedBytes = EncryptedKeyProcessor.getRandomKey(dataRefURIs, elem.getOwnerDocument(), wsDocInfo);
        }
        List<WSDataRef> dataRefs = this.decryptDataRefs(dataRefURIs, elem.getOwnerDocument(), wsDocInfo, decryptedBytes, data);
        WSSecurityEngineResult result2 = new WSSecurityEngineResult(4, decryptedBytes, encryptedEphemeralKey, dataRefs, certs);
        result2.put("encrypted-key-transport-method", encryptedKeyTransportMethod);
        result2.put("id", elem.getAttributeNS(null, "Id"));
        result2.put("x509-reference-type", strParser.getCertificatesReferenceType());
        wsDocInfo.addResult(result2);
        wsDocInfo.addTokenElement(elem);
        return Collections.singletonList(result2);
    }

    private static byte[] getRandomKey(List<String> dataRefURIs, Document doc, WSDocInfo wsDocInfo) throws WSSecurityException {
        try {
            String alg = "AES";
            int size = 128;
            if (!dataRefURIs.isEmpty()) {
                String uri = dataRefURIs.iterator().next();
                Element ee = ReferenceListProcessor.findEncryptedDataElement(doc, wsDocInfo, uri);
                String algorithmURI = X509Util.getEncAlgo(ee);
                alg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                size = WSSecurityUtil.getKeyLength(algorithmURI);
            }
            KeyGenerator kgen = KeyGenerator.getInstance(alg);
            kgen.init(size * 8);
            SecretKey k = kgen.generateKey();
            return k.getEncoded();
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
    }

    private static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuilder sb = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            sb.append(((Text)node).getData());
        }
        String encodedData = sb.toString();
        return Base64.decode(encodedData);
    }

    private static String getDigestAlgorithm(Node encBodyData) throws WSSecurityException {
        Element digestElement;
        Element tmpE = WSSecurityUtil.getDirectChildElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null && (digestElement = WSSecurityUtil.getDirectChildElement(tmpE, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#")) != null) {
            return digestElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    private X509Certificate[] getCertificatesFromEncryptedKey(Element xencEncryptedKey, RequestData data, Crypto crypto, WSDocInfo wsDocInfo, STRParser strParser) throws WSSecurityException {
        Element keyInfo = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfo != null) {
            Element strElement = null;
            if (data.getWssConfig().isWsiBSPCompliant()) {
                int result = 0;
                for (Node node = keyInfo.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (1 != node.getNodeType()) continue;
                    ++result;
                    strElement = (Element)node;
                }
                if (result != 1) {
                    throw new WSSecurityException(3, "invalidDataRef");
                }
            } else {
                strElement = WSSecurityUtil.getDirectChildElement(keyInfo, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            }
            if (strElement == null || strParser == null) {
                throw new WSSecurityException(3, "noSecTokRef");
            }
            strParser.parseSecurityTokenReference(strElement, data, wsDocInfo, null);
            X509Certificate[] certs = strParser.getCertificates();
            if (certs == null || certs.length < 1 || certs[0] == null) {
                throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            return certs;
        }
        if (!data.getWssConfig().isWsiBSPCompliant() && crypto.getDefaultX509Identifier() != null) {
            String alias = crypto.getDefaultX509Identifier();
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(alias);
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            if (certs == null || certs.length < 1 || certs[0] == null) {
                throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            return certs;
        }
        throw new WSSecurityException(3, "noKeyinfo");
    }

    private List<String> getDataRefURIs(Element xencEncryptedKey) {
        Element refList = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        LinkedList<String> dataRefURIs = new LinkedList<String>();
        if (refList != null) {
            for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
                String dataRefURI = ((Element)node).getAttributeNS(null, "URI");
                if (dataRefURI.charAt(0) == '#') {
                    dataRefURI = dataRefURI.substring(1);
                }
                dataRefURIs.add(dataRefURI);
            }
        }
        return dataRefURIs;
    }

    private List<WSDataRef> decryptDataRefs(List<String> dataRefURIs, Document doc, WSDocInfo docInfo, byte[] decryptedBytes, RequestData data) throws WSSecurityException {
        if (dataRefURIs == null || dataRefURIs.isEmpty()) {
            return null;
        }
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        for (String dataRefURI : dataRefURIs) {
            WSDataRef dataRef = this.decryptDataRef(doc, dataRefURI, docInfo, decryptedBytes, data);
            dataRefs.add(dataRef);
        }
        return dataRefs;
    }

    private WSDataRef decryptDataRef(Document doc, String dataRefURI, WSDocInfo docInfo, byte[] decryptedData, RequestData data) throws WSSecurityException {
        Element encryptedDataElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("found data reference: " + dataRefURI));
        }
        if ((encryptedDataElement = ReferenceListProcessor.findEncryptedDataElement(doc, docInfo, dataRefURI)) != null && data.isRequireSignedEncryptedDataElements()) {
            WSSecurityUtil.verifySignedElement(encryptedDataElement, doc, docInfo.getSecurityHeader());
        }
        String symEncAlgo = X509Util.getEncAlgo(encryptedDataElement);
        if (data.getWssConfig().isWsiBSPCompliant() && symEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (!(!data.getWssConfig().isWsiBSPCompliant() || "http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(symEncAlgo))) {
            throw new WSSecurityException(3, "badEncAlgo", new Object[]{symEncAlgo});
        }
        SecretKey symmetricKey = null;
        try {
            symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedData);
        }
        catch (IllegalArgumentException ex) {
            throw new WSSecurityException(2, "badEncAlgo", new Object[]{symEncAlgo}, ex);
        }
        AlgorithmSuite algorithmSuite = data.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkSymmetricKeyLength(symmetricKey.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        return ReferenceListProcessor.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo);
    }

    private void checkBSPCompliance(Element elem, String encAlgo) throws WSSecurityException {
        String attribute = elem.getAttributeNS(null, "Type");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttributeNS(null, "MimeType");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttributeNS(null, "Encoding");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttributeNS(null, "Recipient");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        if (!"http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encAlgo) && !"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encAlgo)) {
            throw new WSSecurityException(3, "badEncAlgo", new Object[]{encAlgo});
        }
    }
}

