/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.pull;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.OMXMLStreamReaderEx;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializer;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMXMLStreamReaderExAdapter
extends StreamReaderDelegate
implements OMXMLStreamReaderEx {
    private static final Log log = LogFactory.getLog(OMXMLStreamReaderExAdapter.class);
    private final PullSerializer serializer;
    private XOPEncodingStreamReader xopEncoder;

    public OMXMLStreamReaderExAdapter(PullSerializer serializer) {
        super((XMLStreamReader)((Object)serializer));
        this.serializer = serializer;
    }

    public boolean isInlineMTOM() {
        return this.xopEncoder == null;
    }

    public void setInlineMTOM(boolean value) {
        if (value) {
            if (this.xopEncoder != null) {
                this.xopEncoder = null;
                this.setParent((XMLStreamReader)((Object)this.serializer));
            }
        } else if (this.xopEncoder == null) {
            this.xopEncoder = new XOPEncodingStreamReader((XMLStreamReader)((Object)this.serializer), ContentIDGenerator.DEFAULT, OptimizationPolicy.ALL);
            this.setParent((XMLStreamReader)this.xopEncoder);
        }
    }

    public DataHandler getDataHandler(String contentID) {
        if (contentID.startsWith("cid:")) {
            log.warn((Object)"Invalid usage of OMStAXWrapper#getDataHandler(String): the argument must be a content ID, not an href; see OMAttachmentAccessor.");
            contentID = contentID.substring(4);
        }
        if (this.xopEncoder == null) {
            throw new IllegalStateException("The wrapper is in inlineMTOM=true mode");
        }
        if (this.xopEncoder.getContentIDs().contains(contentID)) {
            try {
                return this.xopEncoder.getDataHandler(contentID);
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return null;
    }

    public OMDataSource getDataSource() {
        return this.serializer.getDataSource();
    }

    public void enableDataSourceEvents(boolean value) {
        this.serializer.enableDataSourceEvents(value);
    }
}

