/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.TemplateParameterFactory;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName TEMPLATE_Q = new QName("http://ws.apache.org/ns/synapse", "template");
    private static final QName TEMPLATE_BODY_Q = new QName("http://ws.apache.org/ns/synapse", "sequence");

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        TemplateMediator templateTemplateMediator = new TemplateMediator();
        OMAttribute nameAttr = elem.getAttribute(ATT_NAME);
        if (nameAttr == null) {
            String msg = "An EIP template must be a named mediator .";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        templateTemplateMediator.setName(nameAttr.getAttributeValue());
        this.processAuditStatus(templateTemplateMediator, elem);
        templateTemplateMediator.setParameters(TemplateParameterFactory.getTemplateParameters(elem));
        OMElement templateBodyElem = elem.getFirstChildWithName(TEMPLATE_BODY_Q);
        TemplateMediatorFactory.addChildren(templateBodyElem, templateTemplateMediator, properties);
        return templateTemplateMediator;
    }

    @Override
    public QName getTagQName() {
        return TEMPLATE_Q;
    }
}

