/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.AbstractMockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class MockitoBeanOverrideHandler
extends AbstractMockitoBeanOverrideHandler {
    private final Set<Class<?>> extraInterfaces;
    private final Answers answers;
    private final boolean serializable;

    MockitoBeanOverrideHandler(ResolvableType typeToMock, MockitoBean mockitoBean) {
        this(null, typeToMock, mockitoBean);
    }

    MockitoBeanOverrideHandler(@Nullable Field field, ResolvableType typeToMock, MockitoBean mockitoBean) {
        this(field, typeToMock, !mockitoBean.name().isBlank() ? mockitoBean.name() : null, mockitoBean.contextName(), mockitoBean.enforceOverride() ? BeanOverrideStrategy.REPLACE : BeanOverrideStrategy.REPLACE_OR_CREATE, mockitoBean.reset(), mockitoBean.extraInterfaces(), mockitoBean.answers(), mockitoBean.serializable());
    }

    private MockitoBeanOverrideHandler(@Nullable Field field, ResolvableType typeToMock, @Nullable String beanName, String contextName, BeanOverrideStrategy strategy, MockReset reset, Class<?>[] extraInterfaces, Answers answers, boolean serializable) {
        super(field, typeToMock, beanName, contextName, strategy, reset);
        Assert.notNull((Object)typeToMock, (String)"'typeToMock' must not be null");
        this.extraInterfaces = MockitoBeanOverrideHandler.asClassSet(extraInterfaces);
        this.answers = answers;
        this.serializable = serializable;
    }

    private static Set<Class<?>> asClassSet(Class<?>[] classes) {
        if (classes.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet classSet = new LinkedHashSet(Arrays.asList(classes));
        return Collections.unmodifiableSet(classSet);
    }

    Set<Class<?>> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    Answers getAnswers() {
        return this.answers;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    @Override
    protected Object createOverrideInstance(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        return this.createMock(beanName);
    }

    private <T> T createMock(String name) {
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (!this.extraInterfaces.isEmpty()) {
            settings.extraInterfaces(ClassUtils.toClassArray(this.extraInterfaces));
        }
        settings.defaultAnswer((Answer)this.answers);
        if (this.serializable) {
            settings.serializable();
        }
        Class targetType = this.getBeanType().resolve();
        return (T)Mockito.mock((Class)targetType, (MockSettings)settings);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        MockitoBeanOverrideHandler that;
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return other instanceof MockitoBeanOverrideHandler && super.equals(that = (MockitoBeanOverrideHandler)other) && this.serializable == that.serializable && this.answers == that.answers && Objects.equals(this.extraInterfaces, that.extraInterfaces);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.extraInterfaces, this.answers, this.serializable);
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.getField()).append("beanType", (Object)this.getBeanType()).append("beanName", (Object)this.getBeanName()).append("contextName", (Object)this.getContextName()).append("strategy", (Object)this.getStrategy()).append("reset", (Object)this.getReset()).append("extraInterfaces", this.getExtraInterfaces()).append("answers", (Object)this.getAnswers()).append("serializable", this.isSerializable()).toString();
    }
}

