/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.ReportWriter;
import net.sf.jasperreports.engine.xml.ReportWriterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlTemplateWriter {
    private static final Log log = LogFactory.getLog(JRXmlTemplateWriter.class);
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String writeTemplate(JRTemplate template) {
        return JRXmlTemplateWriter.writeTemplate(template, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template) {
        return JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JRTemplate template, String encoding) {
        return JRXmlTemplateWriter.writeTemplate((JasperReportsContext)DefaultJasperReportsContext.getInstance(), template, encoding);
    }

    public static String writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, String encoding) {
        StringWriter stringOut = new StringWriter();
        try {
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, stringOut, encoding);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        return stringOut.toString();
    }

    public static void writeTemplate(JRTemplate template, OutputStream out) {
        JRXmlTemplateWriter.writeTemplate(template, out, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, OutputStream out) {
        JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, out, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JRTemplate template, OutputStream out, String encoding) {
        JRXmlTemplateWriter.writeTemplate((JasperReportsContext)DefaultJasperReportsContext.getInstance(), template, out, encoding);
    }

    public static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, OutputStream out, String encoding) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, writer, encoding);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile) {
        JRXmlTemplateWriter.writeTemplateToFile(template, outputFile, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JasperReportsContext jasperReportsContext, JRTemplate template, String outputFile) {
        JRXmlTemplateWriter.writeTemplateToFile(jasperReportsContext, template, outputFile, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile, String encoding) {
        JRXmlTemplateWriter.writeTemplateToFile(DefaultJasperReportsContext.getInstance(), template, outputFile, encoding);
    }

    public static void writeTemplateToFile(JasperReportsContext jasperReportsContext, JRTemplate template, String outputFile, String encoding) {
        BufferedOutputStream fileOut = null;
        boolean close = true;
        try {
            fileOut = new BufferedOutputStream(new FileOutputStream(outputFile));
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, fileOut, encoding);
            fileOut.flush();
            close = false;
            fileOut.close();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (fileOut != null && close) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close file " + outputFile), (Throwable)e);
                }
            }
        }
    }

    protected static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, Writer out, String encoding) throws IOException {
        List<ReportWriterFactory> writerFactories = jasperReportsContext.getExtensions(ReportWriterFactory.class);
        for (ReportWriterFactory writerFactory : writerFactories) {
            ReportWriter reportWriter = writerFactory.createReportWriter(jasperReportsContext);
            boolean written = reportWriter.writeTemplate(template, encoding, out);
            if (!written) continue;
            return;
        }
        String version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty("net.sf.jasperreports.report.version");
        throw new JRRuntimeException("No template writer found for version " + version + ".");
    }

    private JRXmlTemplateWriter() {
    }
}

