/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.text;

import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.text.TextLayoutAssessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FontTextLayoutAssessor
implements TextLayoutAssessor {
    private static final Log log = LogFactory.getLog(FontTextLayoutAssessor.class);
    private final Method fontLayoutMethod;

    public FontTextLayoutAssessor() {
        Method method;
        try {
            method = Font.class.getMethod("textRequiresLayout", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("java.awt.Font.textRequiresLayout method not found: " + e.getMessage()));
            }
            method = null;
        }
        this.fontLayoutMethod = method;
    }

    public boolean available() {
        return this.fontLayoutMethod != null;
    }

    @Override
    public boolean hasComplexLayout(char[] chars) {
        try {
            return (Boolean)this.fontLayoutMethod.invoke(null, chars, 0, chars.length);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JRRuntimeException(e);
        }
    }
}

