/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;

public class ConvertibleToContent
extends Expression {
    private final Expression subexpression;

    public ConvertibleToContent(Expression subexpression) {
        super(subexpression);
        this.subexpression = Preconditions.checkNotNull(subexpression);
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public Expression withSubexpression(Expression newSubexpression) {
        return newSubexpression.equals(this.subexpression) ? this : new ConvertibleToContent(newSubexpression);
    }

    @Override
    public boolean alwaysEmpty() {
        return this.subexpression.alwaysEmpty();
    }

    @Override
    public boolean alwaysOnlyWhitespace() {
        return this.subexpression.alwaysOnlyWhitespace();
    }

    @Override
    public boolean alwaysEquals(boolean value) {
        return this.subexpression.alwaysEquals(value);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitConvertibleToContent(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof ConvertibleToContent && this.equals((ConvertibleToContent)that);
    }

    public boolean equals(ConvertibleToContent that) {
        return this.equalsExpression(that) && Objects.equal(this.getSubexpression(), that.getSubexpression());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getSubexpression());
    }
}

