/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.storm.common.AbstractAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHBase
extends AbstractAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHBase.class);
    public static final String HBASE_CREDENTIALS = "HBASE_CREDENTIALS";
    public static final String HBASE_KEYTAB_FILE_KEY = "hbase.keytab.file";
    public static final String HBASE_PRINCIPAL_KEY = "hbase.kerberos.principal";
    public String hbaseKeytab;
    public String hbasePrincipal;

    @Override
    public void doPrepare(Map conf) {
        if (conf.containsKey(HBASE_KEYTAB_FILE_KEY) && conf.containsKey(HBASE_PRINCIPAL_KEY)) {
            this.hbaseKeytab = (String)conf.get(HBASE_KEYTAB_FILE_KEY);
            this.hbasePrincipal = (String)conf.get(HBASE_PRINCIPAL_KEY);
        }
    }

    @Override
    protected String getConfigKeyString() {
        return "hbaseCredentialsConfigKeys";
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey, String topologyOwnerPrincipal) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration, topologyOwnerPrincipal);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String topologyOwnerPrincipal) {
        return this.getHadoopCredentials(conf, HBaseConfiguration.create(), topologyOwnerPrincipal);
    }

    private Configuration getHadoopConfiguration(Map topoConf, String configKey) {
        Configuration configuration = HBaseConfiguration.create();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    protected byte[] getHadoopCredentials(Map<String, Object> conf, Configuration hbaseConf, String topologyOwnerPrincipal) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                UserProvider provider = UserProvider.instantiate((Configuration)hbaseConf);
                if (hbaseConf.get(HBASE_KEYTAB_FILE_KEY) == null) {
                    hbaseConf.set(HBASE_KEYTAB_FILE_KEY, this.hbaseKeytab);
                }
                if (hbaseConf.get(HBASE_PRINCIPAL_KEY) == null) {
                    hbaseConf.set(HBASE_PRINCIPAL_KEY, this.hbasePrincipal);
                }
                provider.login(HBASE_KEYTAB_FILE_KEY, HBASE_PRINCIPAL_KEY, InetAddress.getLocalHost().getCanonicalHostName());
                LOG.info("Logged into Hbase as principal = " + hbaseConf.get(HBASE_PRINCIPAL_KEY));
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologyOwnerPrincipal, (UserGroupInformation)ugi);
                User user = User.create((UserGroupInformation)proxyUser);
                if (User.isHBaseSecurityEnabled((Configuration)hbaseConf)) {
                    Connection connection = ConnectionFactory.createConnection((Configuration)hbaseConf, (User)user);
                    TokenUtil.obtainAndCacheToken((Connection)connection, (User)user);
                    LOG.info("Obtained HBase tokens, adding to user credentials.");
                    Credentials credential = proxyUser.getCredentials();
                    for (Token tokenForLog : credential.getAllTokens()) {
                        LOG.debug("Obtained token info in credential: {} / {}", (Object)tokenForLog.toString(), (Object)tokenForLog.decodeIdentifier().getUser());
                    }
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bao);
                    credential.write((DataOutput)out);
                    out.flush();
                    out.close();
                    return bao.toByteArray();
                }
                throw new RuntimeException("Security is not enabled for HBase.");
            }
            throw new RuntimeException("Security is not enabled for Hadoop");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf, String ownerPrincipal) {
        this.populateCredentials(credentials, topologyConf, ownerPrincipal);
    }

    @Override
    protected String getCredentialKey(String configKey) {
        return HBASE_CREDENTIALS + configKey;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String topologyOwnerPrincipal = args[0];
        conf.put(HBASE_PRINCIPAL_KEY, args[1]);
        conf.put(HBASE_KEYTAB_FILE_KEY, args[2]);
        AutoHBase autoHBase = new AutoHBase();
        autoHBase.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHBase.populateCredentials(creds, conf, topologyOwnerPrincipal);
        LOG.info("Got HBase credentials" + autoHBase.getCredentials(creds));
        Subject s = new Subject();
        autoHBase.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHBase.renew(creds, conf, topologyOwnerPrincipal);
        LOG.info("renewed credentials" + autoHBase.getCredentials(creds));
    }

    public void populateCredentials(Map<String, String> credentials, Map topoConf) {
        throw new IllegalStateException("SHOULD NOT BE CALLED");
    }

    public void renew(Map<String, String> credentials, Map topologyConf) {
        throw new IllegalStateException("SHOULD NOT BE CALLED");
    }
}

