/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.inotify.MissingEventsException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DFSInotifyEventInputStream {
    public static Logger LOG = LoggerFactory.getLogger(DFSInotifyEventInputStream.class);
    private final ClientProtocol namenode;
    private Iterator<EventBatch> it;
    private long lastReadTxid;
    private long syncTxid;
    private Random rng = new Random();
    private static final int INITIAL_WAIT_MS = 10;

    DFSInotifyEventInputStream(ClientProtocol namenode) throws IOException {
        this(namenode, namenode.getCurrentEditLogTxid());
    }

    DFSInotifyEventInputStream(ClientProtocol namenode, long lastReadTxid) throws IOException {
        this.namenode = namenode;
        this.it = Iterators.emptyIterator();
        this.lastReadTxid = lastReadTxid;
    }

    public EventBatch poll() throws IOException, MissingEventsException {
        if (this.lastReadTxid == -1L) {
            LOG.debug("poll(): lastReadTxid is -1, reading current txid from NN");
            this.lastReadTxid = this.namenode.getCurrentEditLogTxid();
            return null;
        }
        if (!this.it.hasNext()) {
            EventBatchList el = this.namenode.getEditsFromTxid(this.lastReadTxid + 1L);
            if (el.getLastTxid() != -1L) {
                this.syncTxid = el.getSyncTxid();
                this.it = el.getBatches().iterator();
                long formerLastReadTxid = this.lastReadTxid;
                this.lastReadTxid = el.getLastTxid();
                if (el.getFirstTxid() != formerLastReadTxid + 1L) {
                    throw new MissingEventsException(formerLastReadTxid + 1L, el.getFirstTxid());
                }
            } else {
                LOG.debug("poll(): read no edits from the NN when requesting edits after txid {}", (Object)this.lastReadTxid);
                return null;
            }
        }
        if (this.it.hasNext()) {
            return this.it.next();
        }
        return null;
    }

    public long getTxidsBehindEstimate() {
        if (this.syncTxid == 0L) {
            return -1L;
        }
        assert (this.syncTxid >= this.lastReadTxid);
        return this.syncTxid - this.lastReadTxid;
    }

    public EventBatch poll(long time, TimeUnit tu) throws IOException, InterruptedException, MissingEventsException {
        long initialTime = Time.monotonicNow();
        long totalWait = TimeUnit.MILLISECONDS.convert(time, tu);
        long nextWait = 10L;
        EventBatch next = null;
        while ((next = this.poll()) == null) {
            long timeLeft = totalWait - (Time.monotonicNow() - initialTime);
            if (timeLeft <= 0L) {
                LOG.debug("timed poll(): timed out");
                break;
            }
            nextWait = timeLeft < nextWait * 2L ? timeLeft : (nextWait *= 2L);
            LOG.debug("timed poll(): poll() returned null, sleeping for {} ms", (Object)nextWait);
            Thread.sleep(nextWait);
        }
        return next;
    }

    public EventBatch take() throws IOException, InterruptedException, MissingEventsException {
        EventBatch next = null;
        int nextWaitMin = 10;
        while ((next = this.poll()) == null) {
            int sleepTime = nextWaitMin + this.rng.nextInt(nextWaitMin);
            LOG.debug("take(): poll() returned null, sleeping for {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
            nextWaitMin = Math.min(60000, nextWaitMin * 2);
        }
        return next;
    }
}

