/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.calcite;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.Holder;

public class StormDataContext
implements DataContext,
Serializable {
    private final ImmutableMap<Object, Object> map;

    public StormDataContext() {
        long localOffset;
        Holder timeHolder = Holder.of((Object)System.currentTimeMillis());
        Hook.CURRENT_TIME.run((Object)timeHolder);
        long time = (Long)timeHolder.get();
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        long currentOffset = localOffset = (long)timeZone.getOffset(time);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)time).put((Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)(time + currentOffset)).put((Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)(time + localOffset)).put((Object)DataContext.Variable.TIME_ZONE.camelName, (Object)timeZone);
        this.map = builder.build();
    }

    public SchemaPlus getRootSchema() {
        return null;
    }

    public JavaTypeFactory getTypeFactory() {
        return null;
    }

    public QueryProvider getQueryProvider() {
        return null;
    }

    public Object get(String name) {
        return this.map.get((Object)name);
    }
}

