/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

/**
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class ResourceTypeForcingJakartaRequestWrapperTest {

    @Mock
    private Resource resource;

    @Mock
    private SlingJakartaHttpServletRequest request;

    /**
     * Test method for {@link org.apache.sling.models.impl.via.ResourceTypeForcingJakartaRequestWrapper#getResource()}.
     */
    @Test
    public void testGetResource() {
        // once
        ResourceTypeForcingJakartaRequestWrapper testCase =
                new ResourceTypeForcingJakartaRequestWrapper(request, resource, "foo");
        Resource wrappedResource = testCase.getResource();
        assertTrue(wrappedResource instanceof ResourceTypeForcingResourceWrapper);
        ResourceTypeForcingResourceWrapper resourceTypeForcingResourceWrapper =
                (ResourceTypeForcingResourceWrapper) wrappedResource;
        assertSame(resource, resourceTypeForcingResourceWrapper.getResource());
        assertEquals("foo", resourceTypeForcingResourceWrapper.getResourceType());
    }
}
