/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.sling.jcr.base.internal.RepositoryPrinter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Repository Printer", "service.vendor=The Apache Software Foundation"})
public class RepositoryPrinterProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Long, ServiceRegistration<RepositoryPrinter>> registrations = new HashMap<Long, ServiceRegistration<RepositoryPrinter>>();
    private BundleContext bundleContext;
    private final List<PendingService> pendingServices = new ArrayList<PendingService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(BundleContext ctx) {
        ArrayList<PendingService> copyList;
        List<PendingService> list = this.pendingServices;
        synchronized (list) {
            this.bundleContext = ctx;
            copyList = new ArrayList<PendingService>(this.pendingServices);
            this.pendingServices.clear();
        }
        for (PendingService reg : copyList) {
            this.registerPrinter(this.bundleContext, reg.repository, reg.properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        List<PendingService> list = this.pendingServices;
        synchronized (list) {
            this.bundleContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPrinter(BundleContext processContext, Repository repo, Map<String, Object> props) {
        this.logger.info("Providing new configuration printer for {} : {}", (Object)repo, props);
        Long key = (Long)props.get("service.id");
        RepositoryPrinter printer = new RepositoryPrinter(repo, props);
        ServiceRegistration reg = processContext.registerService(RepositoryPrinter.class, (Object)printer, printer.getProperties());
        Map<Long, ServiceRegistration<RepositoryPrinter>> map = this.registrations;
        synchronized (map) {
            this.registrations.put(key, (ServiceRegistration<RepositoryPrinter>)reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindRepository(Repository repo, Map<String, Object> props) {
        BundleContext processContext;
        List<PendingService> list = this.pendingServices;
        synchronized (list) {
            processContext = this.bundleContext;
            if (processContext == null) {
                this.pendingServices.add(new PendingService(repo, props));
            }
        }
        if (processContext != null) {
            this.registerPrinter(processContext, repo, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindRepository(Repository repo, Map<String, Object> props) {
        ServiceRegistration<RepositoryPrinter> reg;
        List<PendingService> list = this.pendingServices;
        synchronized (list) {
            this.pendingServices.remove(new PendingService(repo, props));
        }
        Long key = (Long)props.get("service.id");
        Map<Long, ServiceRegistration<RepositoryPrinter>> map = this.registrations;
        synchronized (map) {
            reg = this.registrations.remove(key);
        }
        if (reg != null) {
            reg.unregister();
        }
    }

    private static final class PendingService {
        public final Repository repository;
        public final Map<String, Object> properties;
        private final long key;

        public PendingService(Repository r, Map<String, Object> p) {
            this.repository = r;
            this.properties = p;
            this.key = (Long)this.properties.get("service.id");
        }

        public int hashCode() {
            return this.repository.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PendingService)) {
                return false;
            }
            return this.key == ((PendingService)obj).key;
        }
    }
}

