/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.impl;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.hapi.impl.AbstractHapiTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypesCache {
    private static final Logger LOG = LoggerFactory.getLogger(TypesCache.class);
    private static TypesCache singleton = null;
    private HApiUtil hApiUtil;
    Map<String, HApiType> types = new HashMap<String, HApiType>();

    public static TypesCache getInstance(HApiUtil hApiUtil) {
        if (null == singleton) {
            singleton = new TypesCache(hApiUtil);
            LOG.debug("Created new cache instance");
        } else {
            TypesCache.singleton.hApiUtil = hApiUtil;
        }
        LOG.debug("type cache singleton: {}", (Object)singleton);
        return singleton;
    }

    private TypesCache(HApiUtil hApiUtil) {
        this.hApiUtil = hApiUtil;
    }

    public HApiType getType(ResourceResolver resolver, Resource typeResource) throws RepositoryException {
        if (null == typeResource) {
            return new AbstractHapiTypeImpl("Abstract");
        }
        String typePath = typeResource.getPath();
        LOG.debug("Trying to get type {}; cache: {}", (Object)typePath, this.types);
        if (this.types.containsKey(typePath)) {
            LOG.debug("Returning type {} from cache", (Object)typePath);
            return this.types.get(typePath);
        }
        LOG.debug("Creating type {} in cache", (Object)typePath);
        HApiType type = this.hApiUtil.fromPath(resolver, typePath);
        this.types.put(type.getPath(), type);
        return type;
    }

    public void addType(HApiType type) {
        this.types.put(type.getPath(), type);
    }

    public void removeType(String path) {
        this.types.remove(path);
    }

    public String toString() {
        return "TypesCache{types=" + this.types + "}";
    }
}

