/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.File;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.readers.XMLReader;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.apache.sling.jcr.contentloader.internal.readers.JsonReader;
import org.apache.sling.jcr.contentloader.internal.readers.ZipReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContentReaderProvider {
    static final JsonReader jsonReader = new JsonReader();
    static final XMLReader xmlReader = new XMLReader();
    static final ZipReader zipReader = new ZipReader();

    ContentReaderProvider() {
    }

    @Nullable
    ContentReader getContentReaderForEntry(@NotNull File entry, @NotNull PathEntry pathEntry) {
        String entryName = entry.getName();
        if (entryName.endsWith(".json") && !pathEntry.isIgnoredImportProvider("json")) {
            return jsonReader;
        }
        if (entryName.endsWith(".xml") && !pathEntry.isIgnoredImportProvider("xml")) {
            return xmlReader;
        }
        if (entryName.endsWith(".zip") && !pathEntry.isIgnoredImportProvider("zip") || entryName.endsWith(".jar") && !pathEntry.isIgnoredImportProvider("jar")) {
            return zipReader;
        }
        return null;
    }
}

