/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.inline;

import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.impl.JcrBinary;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.inline.InlineAsset;
import io.wcm.sling.commons.util.Escape;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class InlineMediaSource
extends MediaSource {
    @Self
    private Adaptable adaptable;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private MimeTypeService mimeTypeService;
    @NotNull
    public static final String ID = "inline";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public boolean accepts(@NotNull MediaRequest mediaRequest) {
        String mediaSourceId = (String)mediaRequest.getResourceProperties().get("mediaSource", String.class);
        if (StringUtils.isEmpty((CharSequence)mediaSourceId)) {
            return this.getMediaInlineResource(mediaRequest) != null;
        }
        return super.accepts(mediaRequest);
    }

    @Override
    public boolean accepts(@Nullable String mediaRef) {
        return false;
    }

    @Override
    @Nullable
    public String getPrimaryMediaRefProperty() {
        return null;
    }

    @Override
    @NotNull
    public Media resolveMedia(@NotNull Media media) {
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        Resource referencedResource = media.getMediaRequest().getResource();
        Resource ntFileResource = null;
        Resource ntResourceResource = null;
        Resource mediaInlineResource = this.getMediaInlineResource(media.getMediaRequest());
        if (mediaInlineResource != null) {
            if (JcrBinary.isNtFile(mediaInlineResource)) {
                ntFileResource = mediaInlineResource;
                ntResourceResource = mediaInlineResource.getChild("jcr:content");
            } else if (JcrBinary.isNtResource(mediaInlineResource)) {
                ntResourceResource = mediaInlineResource;
            }
        }
        if (ntResourceResource == null) {
            media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_INVALID);
            return media;
        }
        if (StringUtils.isEmpty((CharSequence)mediaArgs.getAltText()) && referencedResource != null) {
            ValueMap props = referencedResource.getValueMap();
            mediaArgs.altText((String)props.get(this.mediaHandlerConfig.getMediaAltTextProperty(), String.class));
        }
        media.setCropDimension(this.getMediaCropDimension(media.getMediaRequest(), this.mediaHandlerConfig));
        media.setRotation(this.getMediaRotation(media.getMediaRequest(), this.mediaHandlerConfig));
        media.setMap(this.getMediaMap(media.getMediaRequest(), this.mediaHandlerConfig));
        String fileName = this.detectFileName(referencedResource, ntFileResource, ntResourceResource);
        fileName = this.cleanupFileName(fileName);
        Asset asset = this.getInlineAsset(ntResourceResource, media, fileName);
        media.setAsset(asset);
        boolean renditionsResolved = this.resolveRenditions(media, asset, mediaArgs);
        if (!renditionsResolved) {
            if (media.getRenditions().isEmpty()) {
                media.setMediaInvalidReason(MediaInvalidReason.NO_MATCHING_RENDITION);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.NOT_ENOUGH_MATCHING_RENDITIONS);
            }
        }
        return media;
    }

    private Asset getInlineAsset(Resource ntResourceResource, Media media, String fileName) {
        return new InlineAsset(ntResourceResource, media, fileName, this.adaptable);
    }

    private String detectFileName(Resource referencedResource, Resource ntFileResource, Resource ntResourceResource) {
        String fileName = null;
        if (ntFileResource != null && !referencedResource.equals(ntFileResource)) {
            fileName = (String)referencedResource.getValueMap().get(ntFileResource.getName() + "Name", String.class);
        } else if (ntFileResource == null && !referencedResource.equals(ntResourceResource)) {
            fileName = (String)referencedResource.getValueMap().get(ntResourceResource.getName() + "Name", String.class);
        } else if (ntFileResource != null) {
            fileName = ntFileResource.getName();
        }
        if (!StringUtils.contains((CharSequence)fileName, (CharSequence)".")) {
            fileName = null;
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String mimeType;
            String fileExtension = null;
            if (ntResourceResource != null && StringUtils.isNotEmpty((CharSequence)(mimeType = (String)ntResourceResource.getValueMap().get("jcr:mimeType", String.class))) && this.mimeTypeService != null) {
                fileExtension = this.mimeTypeService.getExtension(mimeType);
            }
            if (StringUtils.isEmpty(fileExtension)) {
                fileExtension = "bin";
            }
            fileName = "file." + fileExtension;
        }
        return fileName;
    }

    private String cleanupFileName(String fileName) {
        String processedFileName = fileName;
        if (StringUtils.contains((CharSequence)processedFileName, (CharSequence)"/")) {
            processedFileName = StringUtils.substringAfterLast((String)processedFileName, (String)"/");
        }
        if (StringUtils.contains((CharSequence)processedFileName, (CharSequence)"\\")) {
            processedFileName = StringUtils.substringAfterLast((String)processedFileName, (String)"\\");
        }
        processedFileName = Escape.validFilename((String)processedFileName);
        return processedFileName;
    }

    private Resource getMediaInlineResource(MediaRequest mediaRequest) {
        Resource resource = mediaRequest.getResource();
        if (resource == null) {
            return null;
        }
        if (JcrBinary.isNtFileOrResource(resource)) {
            return resource;
        }
        String refProperty = StringUtils.defaultString((String)mediaRequest.getMediaPropertyNames().getRefProperty(), (String)this.mediaHandlerConfig.getMediaInlineNodeName());
        Resource mediaInlineResource = resource.getChild(refProperty);
        if (JcrBinary.isNtFileOrResource(mediaInlineResource)) {
            return mediaInlineResource;
        }
        return null;
    }

    public void enableMediaDrop(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
    }

    public String toString() {
        return ID;
    }
}

