/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.monitor.impl;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.monitor.impl.DistributionQueueMBean;
import org.apache.sling.distribution.monitor.impl.DistributionQueueMBeanImpl;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringDistributionQueueProvider
implements DistributionQueueProvider {
    Logger log = LoggerFactory.getLogger(MonitoringDistributionQueueProvider.class);
    private final Set<String> monitoredQueues = new HashSet<String>();
    private final List<ServiceRegistration<DistributionQueueMBean>> mBeans = new LinkedList<ServiceRegistration<DistributionQueueMBean>>();
    private final DistributionQueueProvider wrapped;
    private final BundleContext context;

    public MonitoringDistributionQueueProvider(DistributionQueueProvider wrapped, BundleContext context) {
        this.wrapped = wrapped;
        this.context = context;
    }

    @Override
    public DistributionQueue getQueue(String queueName) throws DistributionException {
        DistributionQueue distributionQueue = this.wrapped.getQueue(queueName);
        this.monitorQueue(distributionQueue);
        return distributionQueue;
    }

    @Override
    public DistributionQueue getQueue(String queueName, DistributionQueueType type) {
        DistributionQueue distributionQueue = this.wrapped.getQueue(queueName, type);
        this.monitorQueue(distributionQueue);
        return distributionQueue;
    }

    @Override
    public void enableQueueProcessing(DistributionQueueProcessor queueProcessor, String ... queueNames) throws DistributionException {
        this.wrapped.enableQueueProcessing(queueProcessor, queueNames);
    }

    @Override
    public void disableQueueProcessing() throws DistributionException {
        this.wrapped.disableQueueProcessing();
        for (ServiceRegistration<DistributionQueueMBean> mBean : this.mBeans) {
            MonitoringDistributionQueueProvider.safeUnregister(mBean);
        }
        this.mBeans.clear();
        this.monitoredQueues.clear();
    }

    private void monitorQueue(DistributionQueue distributionQueue) {
        try {
            if (this.monitoredQueues.add(distributionQueue.getName())) {
                DistributionQueueMBeanImpl mBean = new DistributionQueueMBeanImpl(distributionQueue);
                Hashtable<String, String> mBeanProps = new Hashtable<String, String>();
                ((Dictionary)mBeanProps).put("jmx.objectname", "org.apache.sling.distribution:type=queue,id=" + ObjectName.quote(distributionQueue.getName()));
                ServiceRegistration mBeanRegistration = this.context.registerService(DistributionQueueMBean.class, (Object)mBean, mBeanProps);
                this.mBeans.add((ServiceRegistration<DistributionQueueMBean>)mBeanRegistration);
            }
        }
        catch (Throwable e) {
            this.log.error("cannot register queue mbean", e);
        }
    }

    private static void safeUnregister(ServiceRegistration<?> serviceRegistration) {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

