/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import java.util.ArrayList;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.publication.PublicationManagerFactory;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=publish"})
public class PublishPostOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(PublishPostOperation.class);
    @Reference
    private PublicationManagerFactory publicationManagerFactory;

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList changes = new ArrayList();
        try {
            response.setPath(request.getResource().getPath());
            this.publicationManagerFactory.getPublicationManager().publish((PublishableResource)request.getResource().adaptTo(PublishableResource.class));
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.onModified(request.getResource().getPath());
        }
        catch (Exception e) {
            log.error("Failed to publish", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

