/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.listeners;

import java.util.Collections;
import java.util.List;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileMetadataExtractorListener.class, ResourceChangeListener.class, ExternalResourceChangeListener.class}, property={"resource.change.types=ADDED", "resource.paths=/content", "resource.paths=/static"}, immediate=true)
public class FileMetadataExtractorListener
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorListener.class);
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory factory;

    public void onChange(List<ResourceChange> changes) {
        try (ResourceResolver serviceResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-metadata"));){
            changes.stream().map(rc -> serviceResolver.getResource(rc.getPath())).filter(r -> "sling:File".equals(r.getResourceType())).forEach(r -> {
                log.debug("Queueing resource {}", r);
                this.jobManager.addJob("org/apache/sling/cms/ExtractMetadata", Collections.singletonMap("path", r.getPath()));
            });
        }
        catch (LoginException e) {
            log.error("Exception getting service user", (Throwable)e);
        }
    }
}

