/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.cms.core.insights.impl.InsightFactoryImpl;
import org.apache.sling.cms.insights.InsightFactory;
import org.apache.sling.cms.insights.InsightProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Web Console Plugin for Apache Sling CMS Insights API", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=slingcms-insights", "felix.webconsole.title=Sling CMS Insights", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Status"}, service={Servlet.class})
public class InsightsWebConsole
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 4819043498961127418L;
    public static final String CONSOLE_LABEL = "slingcms-insights";
    public static final String CONSOLE_TITLE = "Sling CMS Insights";
    @Reference
    private InsightFactory insightFactory;

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter pw = httpServletResponse.getWriter();
        pw.println("<div id='content' class='ui-widget'><br>");
        pw.println("<pre>");
        pw.println("Available Insight Providers");
        pw.println("========================");
        List<InsightProvider> providers = ((InsightFactoryImpl)this.insightFactory).getProviders();
        providers.forEach(p -> {
            pw.println();
            pw.println(p.getTitle() + " (" + p.getClass().getName() + ")");
            pw.println("-------------------------------------");
        });
        pw.println("</pre>");
        pw.println("</div>");
    }
}

