/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.i18n.impl;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.cms.core.i18n.impl.I18NDictionaryImpl;
import org.apache.sling.cms.i18n.I18NDictionary;
import org.apache.sling.cms.i18n.I18NProvider;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.i18n.DefaultLocaleResolver;
import org.apache.sling.i18n.LocaleResolver;
import org.apache.sling.i18n.RequestLocaleResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={I18NProvider.class})
public class I18NProviderImpl
implements I18NProvider {
    private static final Logger log = LoggerFactory.getLogger(I18NProviderImpl.class);
    private final DefaultLocaleResolver defaultLocaleResolver = new DefaultLocaleResolver();
    private LocaleResolver localeResolver = this.defaultLocaleResolver;
    private final Map<Object, ResourceBundleProvider> providers = new TreeMap<Object, ResourceBundleProvider>();
    private RequestLocaleResolver requestLocaleResolver = this.defaultLocaleResolver;
    private ResourceBundleProvider[] sortedProviders = new ResourceBundleProvider[0];

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindLocaleResolver(LocaleResolver resolver) {
        this.localeResolver = resolver;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindRequestLocaleResolver(RequestLocaleResolver resolver) {
        this.requestLocaleResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=ResourceBundleProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.put(ServiceUtil.getComparableForServiceRanking(props, (Order)Order.ASCENDING), provider);
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    public I18NDictionary getDictionary(ResourceResolver resolver) {
        AuthorizableWrapper wrapper = (AuthorizableWrapper)resolver.adaptTo(AuthorizableWrapper.class);
        Locale locale = Optional.ofNullable(wrapper).map(AuthorizableWrapper::getAuthorizable).map(a -> {
            try {
                Value[] val = a.getProperty("profile/locale");
                if (val != null && val.length == 0) {
                    return val[0].getString();
                }
                return Locale.ENGLISH.toLanguageTag();
            }
            catch (RepositoryException e) {
                return Locale.ENGLISH.toLanguageTag();
            }
        }).map(Locale::forLanguageTag).orElse(Locale.ENGLISH);
        CombinedBundleProvider cbp = new CombinedBundleProvider();
        return new I18NDictionaryImpl(cbp.getResourceBundle(locale));
    }

    public I18NDictionary getDictionary(SlingHttpServletRequest request) {
        return this.getDictionary(request.getResourceResolver());
    }

    protected void unbindLocaleResolver(LocaleResolver resolver) {
        if (this.localeResolver == resolver) {
            this.localeResolver = this.defaultLocaleResolver;
        }
    }

    protected void unbindRequestLocaleResolver(RequestLocaleResolver resolver) {
        if (this.requestLocaleResolver == resolver) {
            this.requestLocaleResolver = this.defaultLocaleResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.remove(ServiceUtil.getComparableForServiceRanking(props, (Order)Order.ASCENDING));
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    private class CombinedBundleProvider
    implements ResourceBundleProvider {
        private CombinedBundleProvider() {
        }

        public Locale getDefaultLocale() {
            ResourceBundleProvider[] sp = I18NProviderImpl.this.sortedProviders;
            for (int i = sp.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = sp[i];
                Locale locale = provider.getDefaultLocale();
                if (locale == null) continue;
                log.trace("Found default locale {}", (Object)locale);
                return locale;
            }
            return null;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.getResourceBundle(null, locale);
        }

        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            log.debug("Retrieving resource bundle for {}", (Object)locale);
            ResourceBundleProvider[] sp = I18NProviderImpl.this.sortedProviders;
            for (int i = sp.length - 1; i >= 0; --i) {
                ResourceBundle bundle;
                ResourceBundleProvider provider = sp[i];
                ResourceBundle resourceBundle = bundle = baseName != null ? provider.getResourceBundle(baseName, locale) : provider.getResourceBundle(locale);
                if (bundle == null) continue;
                log.trace("Using bundle {}", (Object)bundle);
                return bundle;
            }
            return null;
        }
    }
}

